﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/tsc/tsc_Types.h>
#include <nn/tsc/tsc_ConfigContexts.h>
#include <nn/tsc/tsc_ActiveConfigContext.h>

#include "tsc_Util.h"

namespace nn { namespace tsc { namespace detail {

class TcpIpStackConfigBase
{

protected:
    TcpIpStackConfigBase()
    {
    }

    virtual ~TcpIpStackConfigBase()
    {
    }

public:
    // Virtual functions
    virtual Result Initialize();
    virtual Result Finalize();

    virtual Result ApplyIpConfig(Ipv4ConfigContext* pInContext, int modeMask);
    virtual Result CleanupConfigContext(const Ipv4ConfigContext* pInContext);
    virtual Result CancelApplyIpConfig();
    virtual Result CheckDuplicateIp(int msecTimeout);
    virtual Result NotifyInterfaceDown(const char* pInInterfaceName);
    virtual Result GetInterfaceStatistics(const char* pInInterfaceName, ActiveConfigContext::InterfaceStatistics* pOutStats);

    virtual Result GetActiveInterfaceAddress(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) = 0;
    virtual Result GetActiveSubnetMask(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) = 0;
    virtual Result GetActiveDefaultGateway(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) = 0;
    virtual Result GetActivePreferredDns(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) = 0;
    virtual Result GetActiveAlternativeDns(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) = 0;
    virtual Result GetActiveMtu(const char* pInInterfaceName, uint32_t* pOutMtuValue) = 0;
};

}}}
