﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/tsc/tsc_Result.h>
#include <nn/tsc/tsc_Arp.h>
#include "tsc_TcpipStackConfigBsd.h"
#include <nn/bsdsocket/cfg/cfg.h>


namespace nn { namespace tsc {


    Result AddStaticArpEntry(nn::socket::InAddr ipAddress, const uint8_t* pInputHardwareAddress, size_t hardwareAddressSize)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::AddStaticArpEntry(ipAddress, pInputHardwareAddress, hardwareAddressSize));
    }

    Result AddStaticArpEntry(in_addr ipAddress, const uint8_t* pInputHardwareAddress, size_t hardwareAddressSize)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::AddStaticArpEntry(ipAddress, pInputHardwareAddress, hardwareAddressSize));
    }

    Result RemoveArpEntry(nn::socket::InAddr ipAddress)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::RemoveArpEntry(ipAddress));
    }

    Result RemoveArpEntry(in_addr ipAddress)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::RemoveArpEntry(ipAddress));
    }

    Result LookupArpEntry(uint8_t* pOutputHardwareAddress, size_t hardwareAddressSize, nn::socket::InAddr ipAddress)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::LookupArpEntry(pOutputHardwareAddress, hardwareAddressSize, ipAddress));
    }

    Result LookupArpEntry(uint8_t* pOutputHardwareAddress, size_t hardwareAddressSize, in_addr ipAddress)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::LookupArpEntry(pOutputHardwareAddress, hardwareAddressSize, ipAddress));
    }

    Result LookupArpEntry(nn::socket::InAddr* pOutputIpAddress, size_t ipAddressSize, const uint8_t* pHardwareAddress, size_t hardwareAddressSize)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::LookupArpEntry(pOutputIpAddress, ipAddressSize, pHardwareAddress, hardwareAddressSize));
    }

    Result LookupArpEntry(in_addr* pOutputIpAddress, size_t ipAddressSize, const uint8_t* pHardwareAddress, size_t hardwareAddressSize)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::LookupArpEntry(pOutputIpAddress, ipAddressSize, pHardwareAddress, hardwareAddressSize));
    }

    Result ClearArpEntries()
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::ClearArpEntries());
    }

    Result ClearArpEntries(const char * ifName)
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::ClearArpEntries(ifName));
    }

    Result PrintArpEntries()
    {
        return detail::ConvertErrorFromBsdcfgToTsc(nn::bsdsocket::cfg::PrintArpEntries());
    }

}}
