﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_TcbId.autogen.h>


//-------------------------------------------------
// Result SetUnsafeLimit(size_t limitSize)
//
//     AArch64 s=8 r=8 p=8            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0       8 limitSize   Register 0       8 limitSize
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler14SetUnsafeLimitEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler14SetUnsafeLimitEm
    .hidden  _ZN2nn3svc7aarch644lp648profiler14SetUnsafeLimitEm
    .type    _ZN2nn3svc7aarch644lp648profiler14SetUnsafeLimitEm, %function
_ZN2nn3svc7aarch644lp648profiler14SetUnsafeLimitEm:

    svc      #NN_SVC_ID_SET_UNSAFE_LIMIT
    ret

    .size _ZN2nn3svc7aarch644lp648profiler14SetUnsafeLimitEm, [.-_ZN2nn3svc7aarch644lp648profiler14SetUnsafeLimitEm]


//-------------------------------------------------
// void SleepSystem()
//
//     AArch64 s=8 r=8 p=8   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler11SleepSystemEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler11SleepSystemEv
    .hidden  _ZN2nn3svc7aarch644lp648profiler11SleepSystemEv
    .type    _ZN2nn3svc7aarch644lp648profiler11SleepSystemEv, %function
_ZN2nn3svc7aarch644lp648profiler11SleepSystemEv:

    svc      #NN_SVC_ID_SLEEP_SYSTEM
    ret

    .size _ZN2nn3svc7aarch644lp648profiler11SleepSystemEv, [.-_ZN2nn3svc7aarch644lp648profiler11SleepSystemEv]


//-------------------------------------------------
// Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     AArch64 s=8 r=8 p=8         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp648profiler13GetSystemInfoEPmNS0_14SystemInfoTypeENS0_6HandleEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler13GetSystemInfoEPmNS0_14SystemInfoTypeENS0_6HandleEm
    .hidden  _ZN2nn3svc7aarch644lp648profiler13GetSystemInfoEPmNS0_14SystemInfoTypeENS0_6HandleEm
    .type    _ZN2nn3svc7aarch644lp648profiler13GetSystemInfoEPmNS0_14SystemInfoTypeENS0_6HandleEm, %function
_ZN2nn3svc7aarch644lp648profiler13GetSystemInfoEPmNS0_14SystemInfoTypeENS0_6HandleEm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_SYSTEM_INFO

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler13GetSystemInfoEPmNS0_14SystemInfoTypeENS0_6HandleEm, [.-_ZN2nn3svc7aarch644lp648profiler13GetSystemInfoEPmNS0_14SystemInfoTypeENS0_6HandleEm]


//-------------------------------------------------
// Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name)
//
//     AArch64 s=8 r=8 p=8              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pOutServer    
//     Register 1  ref  4 pOutClient    
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//     Register 3       1 isLight       Register 3       1 isLight
//     Register 4       8 name          Register 4       8 name
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOutServer
//                                      Register 2       4 pOutClient
//
// conversion
//   Scatter         pOutServer
//   Scatter         pOutClient

    .section .text._ZN2nn3svc7aarch644lp648profiler10CreatePortEPNS0_6HandleES5_ibm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler10CreatePortEPNS0_6HandleES5_ibm
    .hidden  _ZN2nn3svc7aarch644lp648profiler10CreatePortEPNS0_6HandleES5_ibm
    .type    _ZN2nn3svc7aarch644lp648profiler10CreatePortEPNS0_6HandleES5_ibm, %function
_ZN2nn3svc7aarch644lp648profiler10CreatePortEPNS0_6HandleES5_ibm:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_PORT

    ldr      x3, [sp, #0]              // pOutServerのアドレス をスタックからレジスタへ
    str      w1, [x3, #0]              // pOutServer の第 1 ワードをレジスタからメモリへ
    ldr      x3, [sp, #8]              // pOutClientのアドレス をスタックからレジスタへ
    str      w2, [x3, #0]              // pOutClient の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler10CreatePortEPNS0_6HandleES5_ibm, [.-_ZN2nn3svc7aarch644lp648profiler10CreatePortEPNS0_6HandleES5_ibm]


//-------------------------------------------------
// Result ManageNamedPort(nn::svc::Handle* pOutServer, const char name[], int32_t maxSessions)
//
//     AArch64 s=8 r=8 p=8              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pOutServer    
//     Register 1  ref -- name          Register 1  ref -- name
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOutServer
//
// conversion
//   Scatter         pOutServer

    .section .text._ZN2nn3svc7aarch644lp648profiler15ManageNamedPortEPNS0_6HandleEPKci, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler15ManageNamedPortEPNS0_6HandleEPKci
    .hidden  _ZN2nn3svc7aarch644lp648profiler15ManageNamedPortEPNS0_6HandleEPKci
    .type    _ZN2nn3svc7aarch644lp648profiler15ManageNamedPortEPNS0_6HandleEPKci, %function
_ZN2nn3svc7aarch644lp648profiler15ManageNamedPortEPNS0_6HandleEPKci:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_MANAGE_NAMED_PORT

    ldr      x2, [sp, #0]              // pOutServerのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOutServer の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler15ManageNamedPortEPNS0_6HandleEPKci, [.-_ZN2nn3svc7aarch644lp648profiler15ManageNamedPortEPNS0_6HandleEPKci]


//-------------------------------------------------
// Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     AArch64 s=8 r=8 p=8         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 port     Register 1       4 port
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp648profiler13ConnectToPortEPNS0_6HandleES4_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler13ConnectToPortEPNS0_6HandleES4_
    .hidden  _ZN2nn3svc7aarch644lp648profiler13ConnectToPortEPNS0_6HandleES4_
    .type    _ZN2nn3svc7aarch644lp648profiler13ConnectToPortEPNS0_6HandleES4_, %function
_ZN2nn3svc7aarch644lp648profiler13ConnectToPortEPNS0_6HandleES4_:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CONNECT_TO_PORT

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler13ConnectToPortEPNS0_6HandleES4_, [.-_ZN2nn3svc7aarch644lp648profiler13ConnectToPortEPNS0_6HandleES4_]


//-------------------------------------------------
// Result SetProcessMemoryPermission(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission)
//
//     AArch64 s=8 r=8 p=8             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 process      Register 0       4 process
//     Register 1       8 addr         Register 1       8 addr
//     Register 2       8 size         Register 2       8 size
//     Register 3       4 permission   Register 3       4 permission
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler26SetProcessMemoryPermissionENS0_6HandleEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler26SetProcessMemoryPermissionENS0_6HandleEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch644lp648profiler26SetProcessMemoryPermissionENS0_6HandleEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch644lp648profiler26SetProcessMemoryPermissionENS0_6HandleEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch644lp648profiler26SetProcessMemoryPermissionENS0_6HandleEmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_SET_PROCESS_MEMORY_PERMISSION
    ret

    .size _ZN2nn3svc7aarch644lp648profiler26SetProcessMemoryPermissionENS0_6HandleEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch644lp648profiler26SetProcessMemoryPermissionENS0_6HandleEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result MapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=8           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       8 toAddr     Register 0       8 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler16MapProcessMemoryEmNS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler16MapProcessMemoryEmNS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch644lp648profiler16MapProcessMemoryEmNS0_6HandleEmm
    .type    _ZN2nn3svc7aarch644lp648profiler16MapProcessMemoryEmNS0_6HandleEmm, %function
_ZN2nn3svc7aarch644lp648profiler16MapProcessMemoryEmNS0_6HandleEmm:

    svc      #NN_SVC_ID_MAP_PROCESS_MEMORY
    ret

    .size _ZN2nn3svc7aarch644lp648profiler16MapProcessMemoryEmNS0_6HandleEmm, [.-_ZN2nn3svc7aarch644lp648profiler16MapProcessMemoryEmNS0_6HandleEmm]


//-------------------------------------------------
// Result UnmapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=8           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       8 toAddr     Register 0       8 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler18UnmapProcessMemoryEmNS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler18UnmapProcessMemoryEmNS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch644lp648profiler18UnmapProcessMemoryEmNS0_6HandleEmm
    .type    _ZN2nn3svc7aarch644lp648profiler18UnmapProcessMemoryEmNS0_6HandleEmm, %function
_ZN2nn3svc7aarch644lp648profiler18UnmapProcessMemoryEmNS0_6HandleEmm:

    svc      #NN_SVC_ID_UNMAP_PROCESS_MEMORY
    ret

    .size _ZN2nn3svc7aarch644lp648profiler18UnmapProcessMemoryEmNS0_6HandleEmm, [.-_ZN2nn3svc7aarch644lp648profiler18UnmapProcessMemoryEmNS0_6HandleEmm]


//-------------------------------------------------
// Result QueryProcessMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr)
//
//     AArch64 s=8 r=8 p=8             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    
//     Register 2       4 process      Register 2       4 process
//     Register 3       8 addr         Register 3       8 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch644lp648profiler18QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler18QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm
    .hidden  _ZN2nn3svc7aarch644lp648profiler18QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm
    .type    _ZN2nn3svc7aarch644lp648profiler18QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm, %function
_ZN2nn3svc7aarch644lp648profiler18QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm:

    str      x1, [sp, #-16]!

    svc      #NN_SVC_ID_QUERY_PROCESS_MEMORY

    ldr      x2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler18QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm, [.-_ZN2nn3svc7aarch644lp648profiler18QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm]


//-------------------------------------------------
// Result MapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     AArch64 s=8 r=8 p=8           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 toAddr     Register 1       8 toAddr
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler20MapProcessCodeMemoryENS0_6HandleEmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler20MapProcessCodeMemoryENS0_6HandleEmmm
    .hidden  _ZN2nn3svc7aarch644lp648profiler20MapProcessCodeMemoryENS0_6HandleEmmm
    .type    _ZN2nn3svc7aarch644lp648profiler20MapProcessCodeMemoryENS0_6HandleEmmm, %function
_ZN2nn3svc7aarch644lp648profiler20MapProcessCodeMemoryENS0_6HandleEmmm:

    svc      #NN_SVC_ID_MAP_PROCESS_CODE_MEMORY
    ret

    .size _ZN2nn3svc7aarch644lp648profiler20MapProcessCodeMemoryENS0_6HandleEmmm, [.-_ZN2nn3svc7aarch644lp648profiler20MapProcessCodeMemoryENS0_6HandleEmmm]


//-------------------------------------------------
// Result UnmapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     AArch64 s=8 r=8 p=8           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 toAddr     Register 1       8 toAddr
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler22UnmapProcessCodeMemoryENS0_6HandleEmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler22UnmapProcessCodeMemoryENS0_6HandleEmmm
    .hidden  _ZN2nn3svc7aarch644lp648profiler22UnmapProcessCodeMemoryENS0_6HandleEmmm
    .type    _ZN2nn3svc7aarch644lp648profiler22UnmapProcessCodeMemoryENS0_6HandleEmmm, %function
_ZN2nn3svc7aarch644lp648profiler22UnmapProcessCodeMemoryENS0_6HandleEmmm:

    svc      #NN_SVC_ID_UNMAP_PROCESS_CODE_MEMORY
    ret

    .size _ZN2nn3svc7aarch644lp648profiler22UnmapProcessCodeMemoryENS0_6HandleEmmm, [.-_ZN2nn3svc7aarch644lp648profiler22UnmapProcessCodeMemoryENS0_6HandleEmmm]


//-------------------------------------------------
// Result CreateProcess(nn::svc::Handle* pOut, const nn::svc::lp64::CreateProcessParameter& params, const nn::Bit32 flags[], int32_t flagsNum)
//
//     AArch64 s=8 r=8 p=8           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0  ref  4 pOut       
//     Register 1  ref 48 params     Register 1  ref 48 params
//     Register 2  ref -- flags      Register 2  ref -- flags
//     Register 3       4 flagsNum   Register 3       4 flagsNum
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp648profiler13CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler13CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji
    .hidden  _ZN2nn3svc7aarch644lp648profiler13CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji
    .type    _ZN2nn3svc7aarch644lp648profiler13CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji, %function
_ZN2nn3svc7aarch644lp648profiler13CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_PROCESS

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler13CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji, [.-_ZN2nn3svc7aarch644lp648profiler13CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji]


//-------------------------------------------------
// Result StartProcess(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize)
//
//     AArch64 s=8 r=8 p=8            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0       4 runner      Register 0       4 runner
//     Register 1       4 priority    Register 1       4 priority
//     Register 2       4 coreNo      Register 2       4 coreNo
//     Register 3       8 stackSize   Register 3       8 stackSize
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler12StartProcessENS0_6HandleEiim, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler12StartProcessENS0_6HandleEiim
    .hidden  _ZN2nn3svc7aarch644lp648profiler12StartProcessENS0_6HandleEiim
    .type    _ZN2nn3svc7aarch644lp648profiler12StartProcessENS0_6HandleEiim, %function
_ZN2nn3svc7aarch644lp648profiler12StartProcessENS0_6HandleEiim:

    svc      #NN_SVC_ID_START_PROCESS
    ret

    .size _ZN2nn3svc7aarch644lp648profiler12StartProcessENS0_6HandleEiim, [.-_ZN2nn3svc7aarch644lp648profiler12StartProcessENS0_6HandleEiim]


//-------------------------------------------------
// Result TerminateProcess(nn::svc::Handle process)
//
//     AArch64 s=8 r=8 p=8          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler16TerminateProcessENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler16TerminateProcessENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch644lp648profiler16TerminateProcessENS0_6HandleE
    .type    _ZN2nn3svc7aarch644lp648profiler16TerminateProcessENS0_6HandleE, %function
_ZN2nn3svc7aarch644lp648profiler16TerminateProcessENS0_6HandleE:

    svc      #NN_SVC_ID_TERMINATE_PROCESS
    ret

    .size _ZN2nn3svc7aarch644lp648profiler16TerminateProcessENS0_6HandleE, [.-_ZN2nn3svc7aarch644lp648profiler16TerminateProcessENS0_6HandleE]


//-------------------------------------------------
// Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type)
//
//     AArch64 s=8 r=8 p=8         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 handle   Register 1       4 handle
//     Register 2       4 type     Register 2       4 type
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp648profiler14GetProcessInfoEPlNS0_6HandleENS0_15ProcessInfoTypeE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler14GetProcessInfoEPlNS0_6HandleENS0_15ProcessInfoTypeE
    .hidden  _ZN2nn3svc7aarch644lp648profiler14GetProcessInfoEPlNS0_6HandleENS0_15ProcessInfoTypeE
    .type    _ZN2nn3svc7aarch644lp648profiler14GetProcessInfoEPlNS0_6HandleENS0_15ProcessInfoTypeE, %function
_ZN2nn3svc7aarch644lp648profiler14GetProcessInfoEPlNS0_6HandleENS0_15ProcessInfoTypeE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_PROCESS_INFO

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler14GetProcessInfoEPlNS0_6HandleENS0_15ProcessInfoTypeE, [.-_ZN2nn3svc7aarch644lp648profiler14GetProcessInfoEPlNS0_6HandleENS0_15ProcessInfoTypeE]


//-------------------------------------------------
// Result CreateResourceLimit(nn::svc::Handle* pOut)
//
//     AArch64 s=8 r=8 p=8         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp648profiler19CreateResourceLimitEPNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler19CreateResourceLimitEPNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch644lp648profiler19CreateResourceLimitEPNS0_6HandleE
    .type    _ZN2nn3svc7aarch644lp648profiler19CreateResourceLimitEPNS0_6HandleE, %function
_ZN2nn3svc7aarch644lp648profiler19CreateResourceLimitEPNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_RESOURCE_LIMIT

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp648profiler19CreateResourceLimitEPNS0_6HandleE, [.-_ZN2nn3svc7aarch644lp648profiler19CreateResourceLimitEPNS0_6HandleE]


//-------------------------------------------------
// Result SetResourceLimitLimitValue(nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value)
//
//     AArch64 s=8 r=8 p=8                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0       4 resourceLimit   Register 0       4 resourceLimit
//     Register 1       4 resource        Register 1       4 resource
//     Register 2       8 value           Register 2       8 value
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler26SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEl, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler26SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEl
    .hidden  _ZN2nn3svc7aarch644lp648profiler26SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEl
    .type    _ZN2nn3svc7aarch644lp648profiler26SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEl, %function
_ZN2nn3svc7aarch644lp648profiler26SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEl:

    svc      #NN_SVC_ID_SET_RESOURCE_LIMIT_LIMIT_VALUE
    ret

    .size _ZN2nn3svc7aarch644lp648profiler26SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEl, [.-_ZN2nn3svc7aarch644lp648profiler26SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEl]


//-------------------------------------------------
// void CallSecureMonitor()
//
//     AArch64 s=8 r=8 p=8   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp648profiler17CallSecureMonitorEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp648profiler17CallSecureMonitorEv
    .hidden  _ZN2nn3svc7aarch644lp648profiler17CallSecureMonitorEv
    .type    _ZN2nn3svc7aarch644lp648profiler17CallSecureMonitorEv, %function
_ZN2nn3svc7aarch644lp648profiler17CallSecureMonitorEv:

    svc      #NN_SVC_ID_CALL_SECURE_MONITOR
    ret

    .size _ZN2nn3svc7aarch644lp648profiler17CallSecureMonitorEv, [.-_ZN2nn3svc7aarch644lp648profiler17CallSecureMonitorEv]


    .end

