﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_ServerId.autogen.h>


//-------------------------------------------------
// Result CreateSession(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name)
//
//     AArch32 s=4 r=4 p=4                 Invariant s=4 r=8 p=4
// in  abi                                 svc
//     Register 0  ref  4 pServerSession   
//     Register 1  ref  4 pClientSession   
//     Register 2       1 isLight          Register 2       1 isLight
//     Register 3       4 name             Register 3       4 name
//
// out abi                                 svc
//     Register 0       4 return           Register 0       4 return
//                                         Register 1       4 pServerSession
//                                         Register 2       4 pClientSession
//
// conversion
//   Scatter         pServerSession
//   Scatter         pClientSession

    .section .text._ZN2nn3svc7aarch328profiler13CreateSessionEPNS0_6HandleES4_bj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler13CreateSessionEPNS0_6HandleES4_bj
    .hidden  _ZN2nn3svc7aarch328profiler13CreateSessionEPNS0_6HandleES4_bj
    .type    _ZN2nn3svc7aarch328profiler13CreateSessionEPNS0_6HandleES4_bj, %function
_ZN2nn3svc7aarch328profiler13CreateSessionEPNS0_6HandleES4_bj:

    push     {r0,r1}

    svc      #NN_SVC_ID_CREATE_SESSION

    ldr      r3, [sp, #0]              // pServerSessionのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pServerSession の第 1 ワードをレジスタからメモリへ
    ldr      r3, [sp, #4]              // pClientSessionのアドレス をスタックからレジスタへ
    str      r2, [r3, #0]              // pClientSession の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #8
    bx       lr

    .size _ZN2nn3svc7aarch328profiler13CreateSessionEPNS0_6HandleES4_bj, [.-_ZN2nn3svc7aarch328profiler13CreateSessionEPNS0_6HandleES4_bj]


//-------------------------------------------------
// Result AcceptSession(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 port     Register 1       4 port
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler13AcceptSessionEPNS0_6HandleES3_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler13AcceptSessionEPNS0_6HandleES3_
    .hidden  _ZN2nn3svc7aarch328profiler13AcceptSessionEPNS0_6HandleES3_
    .type    _ZN2nn3svc7aarch328profiler13AcceptSessionEPNS0_6HandleES3_, %function
_ZN2nn3svc7aarch328profiler13AcceptSessionEPNS0_6HandleES3_:

    push     {r0}

    svc      #NN_SVC_ID_ACCEPT_SESSION

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler13AcceptSessionEPNS0_6HandleES3_, [.-_ZN2nn3svc7aarch328profiler13AcceptSessionEPNS0_6HandleES3_]


//-------------------------------------------------
// Result ReplyAndReceiveLight(nn::svc::Handle session)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler20ReplyAndReceiveLightENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler20ReplyAndReceiveLightENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler20ReplyAndReceiveLightENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler20ReplyAndReceiveLightENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler20ReplyAndReceiveLightENS0_6HandleE:

    svc      #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    bx       lr

    .size _ZN2nn3svc7aarch328profiler20ReplyAndReceiveLightENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler20ReplyAndReceiveLightENS0_6HandleE]


//-------------------------------------------------
// Result ReplyAndReceive(int32_t* pIndex, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     AArch32 s=4 r=4 p=4              Invariant s=4 r=8 p=4
// in  abi                              svc
//     Register 0  ref  4 pIndex        Register 0       8 ns
//     Register 1  ref -- pHandles      Register 1  ref -- pHandles
//     Register 2       4 numHandle     Register 2       4 numHandle
//     Register 3       4 replyTarget   Register 3       4 replyTarget
//                                      Register 4       8 ns
//     Stack    0       8 ns            
//     Stack    1       8 ns            
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pIndex
//
// conversion
//   Load            ns
//   Load            ns
//   Scatter         pIndex

    .section .text._ZN2nn3svc7aarch328profiler15ReplyAndReceiveEPiPKNS0_6HandleEiS4_x, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler15ReplyAndReceiveEPiPKNS0_6HandleEiS4_x
    .hidden  _ZN2nn3svc7aarch328profiler15ReplyAndReceiveEPiPKNS0_6HandleEiS4_x
    .type    _ZN2nn3svc7aarch328profiler15ReplyAndReceiveEPiPKNS0_6HandleEiS4_x, %function
_ZN2nn3svc7aarch328profiler15ReplyAndReceiveEPiPKNS0_6HandleEiS4_x:

    push     {r0,r4}

    ldr      r0, [sp, #8]              // ns の値 をスタックからレジスタへ
    ldr      r4, [sp, #12]             // ns の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_REPLY_AND_RECEIVE

    ldr      r2, [sp, #0]              // pIndexのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pIndex の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler15ReplyAndReceiveEPiPKNS0_6HandleEiS4_x, [.-_ZN2nn3svc7aarch328profiler15ReplyAndReceiveEPiPKNS0_6HandleEiS4_x]


//-------------------------------------------------
// Result ReplyAndReceiveWithUserBuffer(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     AArch32 s=4 r=4 p=4              Invariant s=4 r=8 p=4
// in  abi                              svc
//     Register 0  ref  4 pIndex        Register 0       4 numHandle
//     Register 1       4 pMessage      Register 1       4 pMessage
//     Register 2       4 bufferSize    Register 2       4 bufferSize
//     Register 3  ref -- pHandles      Register 3  ref -- pHandles
//                                      Register 4       4 replyTarget
//                                      Register 5       8 ns
//                                      Register 6       8 ns
//     Stack    0       4 numHandle     
//     Stack    1       4 replyTarget   
//     Stack    2       8 ns            
//     Stack    3       8 ns            
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pIndex
//
// conversion
//   Load            numHandle
//   Load            replyTarget
//   Load            ns
//   Load            ns
//   Scatter         pIndex

    .section .text._ZN2nn3svc7aarch328profiler29ReplyAndReceiveWithUserBufferEPijjPKNS0_6HandleEiS4_x, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler29ReplyAndReceiveWithUserBufferEPijjPKNS0_6HandleEiS4_x
    .hidden  _ZN2nn3svc7aarch328profiler29ReplyAndReceiveWithUserBufferEPijjPKNS0_6HandleEiS4_x
    .type    _ZN2nn3svc7aarch328profiler29ReplyAndReceiveWithUserBufferEPijjPKNS0_6HandleEiS4_x, %function
_ZN2nn3svc7aarch328profiler29ReplyAndReceiveWithUserBufferEPijjPKNS0_6HandleEiS4_x:

    push     {r0,r4,r5,r6}

    ldr      r0, [sp, #16]             // numHandle の値 をスタックからレジスタへ
    ldr      r4, [sp, #20]             // replyTarget の値 をスタックからレジスタへ
    ldr      r5, [sp, #24]             // ns の値 をスタックからレジスタへ
    ldr      r6, [sp, #28]             // ns の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_REPLY_AND_RECEIVE_WITH_USER_BUFFER

    ldr      r2, [sp, #0]              // pIndexのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pIndex の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    pop      {r4,r5,r6}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler29ReplyAndReceiveWithUserBufferEPijjPKNS0_6HandleEiS4_x, [.-_ZN2nn3svc7aarch328profiler29ReplyAndReceiveWithUserBufferEPijjPKNS0_6HandleEiS4_x]


//-------------------------------------------------
// Result CreateEvent(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle)
//
//     AArch32 s=4 r=4 p=4               Invariant s=4 r=8 p=4
// in  abi                               svc
//     Register 0  ref  4 pWriteHandle   
//     Register 1  ref  4 pReadHandle    
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//                                       Register 1       4 pWriteHandle
//                                       Register 2       4 pReadHandle
//
// conversion
//   Scatter         pWriteHandle
//   Scatter         pReadHandle

    .section .text._ZN2nn3svc7aarch328profiler11CreateEventEPNS0_6HandleES4_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11CreateEventEPNS0_6HandleES4_
    .hidden  _ZN2nn3svc7aarch328profiler11CreateEventEPNS0_6HandleES4_
    .type    _ZN2nn3svc7aarch328profiler11CreateEventEPNS0_6HandleES4_, %function
_ZN2nn3svc7aarch328profiler11CreateEventEPNS0_6HandleES4_:

    push     {r0,r1}

    svc      #NN_SVC_ID_CREATE_EVENT

    ldr      r3, [sp, #0]              // pWriteHandleのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pWriteHandle の第 1 ワードをレジスタからメモリへ
    ldr      r3, [sp, #4]              // pReadHandleのアドレス をスタックからレジスタへ
    str      r2, [r3, #0]              // pReadHandle の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #8
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11CreateEventEPNS0_6HandleES4_, [.-_ZN2nn3svc7aarch328profiler11CreateEventEPNS0_6HandleES4_]


//-------------------------------------------------
// Result MapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 size     Register 1       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler23MapPhysicalMemoryUnsafeEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler23MapPhysicalMemoryUnsafeEjj
    .hidden  _ZN2nn3svc7aarch328profiler23MapPhysicalMemoryUnsafeEjj
    .type    _ZN2nn3svc7aarch328profiler23MapPhysicalMemoryUnsafeEjj, %function
_ZN2nn3svc7aarch328profiler23MapPhysicalMemoryUnsafeEjj:

    svc      #NN_SVC_ID_MAP_PHYSICAL_MEMORY_UNSAFE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler23MapPhysicalMemoryUnsafeEjj, [.-_ZN2nn3svc7aarch328profiler23MapPhysicalMemoryUnsafeEjj]


//-------------------------------------------------
// Result UnmapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 size     Register 1       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler25UnmapPhysicalMemoryUnsafeEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler25UnmapPhysicalMemoryUnsafeEjj
    .hidden  _ZN2nn3svc7aarch328profiler25UnmapPhysicalMemoryUnsafeEjj
    .type    _ZN2nn3svc7aarch328profiler25UnmapPhysicalMemoryUnsafeEjj, %function
_ZN2nn3svc7aarch328profiler25UnmapPhysicalMemoryUnsafeEjj:

    svc      #NN_SVC_ID_UNMAP_PHYSICAL_MEMORY_UNSAFE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler25UnmapPhysicalMemoryUnsafeEjj, [.-_ZN2nn3svc7aarch328profiler25UnmapPhysicalMemoryUnsafeEjj]


    .end

