﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_BaseType.h>
#include <nn/svc/svc_DdType.h>
#include <nn/svc/svc_DmntType.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_ServerType.h>
#include <nn/svc/svc_TcbType.h>

#ifdef __cplusplus

namespace nn {
namespace svc {
namespace aarch64 {
namespace ilp32 {
namespace profiler {

Result SetHeapSize(uintptr_t* pOut, size_t size);
Result SetMemoryPermission(uintptr_t addr, size_t size, nn::svc::MemoryPermission permission);
Result SetMemoryAttribute(uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute);
Result MapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size);
Result UnmapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size);
Result QueryMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr);
void ExitProcess();
Result CreateThread(nn::svc::Handle* pOut, nn::svc::lp64::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore);
Result StartThread(nn::svc::Handle thread);
void ExitThread();
void SleepThread(int64_t ns);
Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread);
Result SetThreadPriority(nn::svc::Handle thread, int32_t priority);
Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread);
Result SetThreadCoreMask(nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask);
int32_t GetCurrentProcessorNumber();
Result SignalEvent(nn::svc::Handle event);
Result ClearEvent(nn::svc::Handle event);
Result MapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
Result UnmapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size);
Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
Result CloseHandle(nn::svc::Handle handle);
Result ResetSignal(nn::svc::Handle handle);
Result WaitSynchronization(int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns);
Result CancelSynchronization(nn::svc::Handle handle);
Result ArbitrateLock(nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue);
Result ArbitrateUnlock(uintptr_t addr);
Result WaitProcessWideKeyAtomic(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns);
void SignalProcessWideKey(uintptr_t cvKey, int32_t num);
int64_t GetSystemTick();
Result ConnectToNamedPort(nn::svc::Handle* pOut, const char name[]);
Result SendSyncRequestLight(nn::svc::Handle session);
Result SendSyncRequest(nn::svc::Handle session);
Result SendSyncRequestWithUserBuffer(uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process);
Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread);
void Break(nn::svc::BreakReason reason, uintptr_t data, size_t length);
Result OutputDebugString(const char text[], size_t length);
void ReturnFromException(nn::Result result);
Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param);
void FlushEntireDataCache();
Result FlushDataCache(uintptr_t addr, size_t size);
Result MapPhysicalMemory(uintptr_t addr, size_t size);
Result UnmapPhysicalMemory(uintptr_t addr, size_t size);
Result GetDebugFutureThreadInfo(nn::svc::lp64::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns);
Result GetLastThreadInfo(nn::svc::lp64::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag);
Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
Result SetThreadActivity(nn::svc::Handle handle, nn::svc::ThreadActivity activity);
Result GetThreadContext3(nn::svc::ThreadContext* pContext, nn::svc::Handle handle);
Result WaitForAddress(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns);
Result SignalToAddress(uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num);
void KernelDebug(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2);
void ChangeKernelTraceState(nn::svc::KernelTraceState state);
Result CreateSession(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name);
Result AcceptSession(nn::svc::Handle* pOut, nn::svc::Handle port);
Result ReplyAndReceiveLight(nn::svc::Handle session);
Result ReplyAndReceive(int32_t* pIndex, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
Result ReplyAndReceiveWithUserBuffer(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
Result CreateEvent(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle);
Result MapPhysicalMemoryUnsafe(uintptr_t addr, size_t size);
Result UnmapPhysicalMemoryUnsafe(uintptr_t addr, size_t size);
Result SetUnsafeLimit(size_t limitSize);
Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size);
Result ControlCodeMemory(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission);
void SleepSystem();
Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value);
Result SetProcessActivity(nn::svc::Handle handle, nn::svc::ProcessActivity activity);
Result CreateSharedMemory(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission);
Result MapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission);
Result UnmapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size);
Result CreateInterruptEvent(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type);
Result QueryPhysicalAddress(nn::svc::lp64::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr);
Result QueryIoMapping(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size);
Result CreateDeviceAddressSpace(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize);
Result AttachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle);
Result DetachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle);
Result MapDeviceAddressSpaceByForce(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
Result MapDeviceAddressSpaceAligned(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
Result MapDeviceAddressSpace(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
Result UnmapDeviceAddressSpace(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress);
Result InvalidateProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size);
Result StoreProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size);
Result FlushProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size);
Result DebugActiveProcess(nn::svc::Handle* pOut, nn::Bit64 processId);
Result BreakDebugProcess(nn::svc::Handle debug);
Result TerminateDebugProcess(nn::svc::Handle debug);
Result GetDebugEvent(nn::svc::lp64::DebugEventInfo* pInfo, nn::svc::Handle debug);
Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::Bit64 pThreadIds[], int32_t arraySize);
Result GetProcessList(int32_t* pNumProcesses, nn::Bit64 pProcessIds[], int32_t arraySize);
Result GetThreadList(int32_t* pNumThreads, nn::Bit64 pThreadIds[], int32_t arraySize, nn::svc::Handle domain);
Result GetDebugThreadContext(nn::svc::ThreadContext* pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags);
Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::svc::ThreadContext& context, nn::Bit32 controlFlags);
Result QueryDebugProcessMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr);
Result ReadDebugProcessMemory(uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size);
Result WriteDebugProcessMemory(nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size);
Result SetHardwareBreakPoint(nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value);
Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select);
Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param);
Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name);
Result ManageNamedPort(nn::svc::Handle* pOutServer, const char name[], int32_t maxSessions);
Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port);
Result SetProcessMemoryPermission(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission);
Result MapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
Result UnmapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
Result QueryProcessMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr);
Result MapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
Result UnmapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
Result CreateProcess(nn::svc::Handle* pOut, const nn::svc::lp64::CreateProcessParameter& params, const nn::Bit32 flags[], int32_t flagsNum);
Result StartProcess(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize);
Result TerminateProcess(nn::svc::Handle process);
Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type);
Result CreateResourceLimit(nn::svc::Handle* pOut);
Result SetResourceLimitLimitValue(nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value);
void CallSecureMonitor();

void* handlerTable[128] =
{
    /*   0 */  NULL,
    /*   1 */  reinterpret_cast<void*>(SetHeapSize),
    /*   2 */  reinterpret_cast<void*>(SetMemoryPermission),
    /*   3 */  reinterpret_cast<void*>(SetMemoryAttribute),
    /*   4 */  reinterpret_cast<void*>(MapMemory),
    /*   5 */  reinterpret_cast<void*>(UnmapMemory),
    /*   6 */  reinterpret_cast<void*>(QueryMemory),
    /*   7 */  reinterpret_cast<void*>(ExitProcess),
    /*   8 */  reinterpret_cast<void*>(CreateThread),
    /*   9 */  reinterpret_cast<void*>(StartThread),
    /*  10 */  reinterpret_cast<void*>(ExitThread),
    /*  11 */  reinterpret_cast<void*>(SleepThread),
    /*  12 */  reinterpret_cast<void*>(GetThreadPriority),
    /*  13 */  reinterpret_cast<void*>(SetThreadPriority),
    /*  14 */  reinterpret_cast<void*>(GetThreadCoreMask),
    /*  15 */  reinterpret_cast<void*>(SetThreadCoreMask),
    /*  16 */  reinterpret_cast<void*>(GetCurrentProcessorNumber),
    /*  17 */  reinterpret_cast<void*>(SignalEvent),
    /*  18 */  reinterpret_cast<void*>(ClearEvent),
    /*  19 */  reinterpret_cast<void*>(MapSharedMemory),
    /*  20 */  reinterpret_cast<void*>(UnmapSharedMemory),
    /*  21 */  reinterpret_cast<void*>(CreateTransferMemory),
    /*  22 */  reinterpret_cast<void*>(CloseHandle),
    /*  23 */  reinterpret_cast<void*>(ResetSignal),
    /*  24 */  reinterpret_cast<void*>(WaitSynchronization),
    /*  25 */  reinterpret_cast<void*>(CancelSynchronization),
    /*  26 */  reinterpret_cast<void*>(ArbitrateLock),
    /*  27 */  reinterpret_cast<void*>(ArbitrateUnlock),
    /*  28 */  reinterpret_cast<void*>(WaitProcessWideKeyAtomic),
    /*  29 */  reinterpret_cast<void*>(SignalProcessWideKey),
    /*  30 */  reinterpret_cast<void*>(GetSystemTick),
    /*  31 */  reinterpret_cast<void*>(ConnectToNamedPort),
    /*  32 */  reinterpret_cast<void*>(SendSyncRequestLight),
    /*  33 */  reinterpret_cast<void*>(SendSyncRequest),
    /*  34 */  reinterpret_cast<void*>(SendSyncRequestWithUserBuffer),
    /*  35 */  reinterpret_cast<void*>(SendAsyncRequestWithUserBuffer),
    /*  36 */  reinterpret_cast<void*>(GetProcessId),
    /*  37 */  reinterpret_cast<void*>(GetThreadId),
    /*  38 */  reinterpret_cast<void*>(Break),
    /*  39 */  reinterpret_cast<void*>(OutputDebugString),
    /*  40 */  reinterpret_cast<void*>(ReturnFromException),
    /*  41 */  reinterpret_cast<void*>(GetInfo),
    /*  42 */  reinterpret_cast<void*>(FlushEntireDataCache),
    /*  43 */  reinterpret_cast<void*>(FlushDataCache),
    /*  44 */  reinterpret_cast<void*>(MapPhysicalMemory),
    /*  45 */  reinterpret_cast<void*>(UnmapPhysicalMemory),
    /*  46 */  reinterpret_cast<void*>(GetDebugFutureThreadInfo),
    /*  47 */  reinterpret_cast<void*>(GetLastThreadInfo),
    /*  48 */  reinterpret_cast<void*>(GetResourceLimitLimitValue),
    /*  49 */  reinterpret_cast<void*>(GetResourceLimitCurrentValue),
    /*  50 */  reinterpret_cast<void*>(SetThreadActivity),
    /*  51 */  reinterpret_cast<void*>(GetThreadContext3),
    /*  52 */  reinterpret_cast<void*>(WaitForAddress),
    /*  53 */  reinterpret_cast<void*>(SignalToAddress),
    /*  54 */  NULL,
    /*  55 */  NULL,
    /*  56 */  NULL,
    /*  57 */  NULL,
    /*  58 */  NULL,
    /*  59 */  NULL,
    /*  60 */  reinterpret_cast<void*>(KernelDebug),
    /*  61 */  reinterpret_cast<void*>(ChangeKernelTraceState),
    /*  62 */  NULL,
    /*  63 */  NULL,
    /*  64 */  reinterpret_cast<void*>(CreateSession),
    /*  65 */  reinterpret_cast<void*>(AcceptSession),
    /*  66 */  reinterpret_cast<void*>(ReplyAndReceiveLight),
    /*  67 */  reinterpret_cast<void*>(ReplyAndReceive),
    /*  68 */  reinterpret_cast<void*>(ReplyAndReceiveWithUserBuffer),
    /*  69 */  reinterpret_cast<void*>(CreateEvent),
    /*  70 */  NULL,
    /*  71 */  NULL,
    /*  72 */  reinterpret_cast<void*>(MapPhysicalMemoryUnsafe),
    /*  73 */  reinterpret_cast<void*>(UnmapPhysicalMemoryUnsafe),
    /*  74 */  reinterpret_cast<void*>(SetUnsafeLimit),
    /*  75 */  reinterpret_cast<void*>(CreateCodeMemory),
    /*  76 */  reinterpret_cast<void*>(ControlCodeMemory),
    /*  77 */  reinterpret_cast<void*>(SleepSystem),
    /*  78 */  reinterpret_cast<void*>(ReadWriteRegister),
    /*  79 */  reinterpret_cast<void*>(SetProcessActivity),
    /*  80 */  reinterpret_cast<void*>(CreateSharedMemory),
    /*  81 */  reinterpret_cast<void*>(MapTransferMemory),
    /*  82 */  reinterpret_cast<void*>(UnmapTransferMemory),
    /*  83 */  reinterpret_cast<void*>(CreateInterruptEvent),
    /*  84 */  reinterpret_cast<void*>(QueryPhysicalAddress),
    /*  85 */  reinterpret_cast<void*>(QueryIoMapping),
    /*  86 */  reinterpret_cast<void*>(CreateDeviceAddressSpace),
    /*  87 */  reinterpret_cast<void*>(AttachDeviceAddressSpace),
    /*  88 */  reinterpret_cast<void*>(DetachDeviceAddressSpace),
    /*  89 */  reinterpret_cast<void*>(MapDeviceAddressSpaceByForce),
    /*  90 */  reinterpret_cast<void*>(MapDeviceAddressSpaceAligned),
    /*  91 */  reinterpret_cast<void*>(MapDeviceAddressSpace),
    /*  92 */  reinterpret_cast<void*>(UnmapDeviceAddressSpace),
    /*  93 */  reinterpret_cast<void*>(InvalidateProcessDataCache),
    /*  94 */  reinterpret_cast<void*>(StoreProcessDataCache),
    /*  95 */  reinterpret_cast<void*>(FlushProcessDataCache),
    /*  96 */  reinterpret_cast<void*>(DebugActiveProcess),
    /*  97 */  reinterpret_cast<void*>(BreakDebugProcess),
    /*  98 */  reinterpret_cast<void*>(TerminateDebugProcess),
    /*  99 */  reinterpret_cast<void*>(GetDebugEvent),
    /* 100 */  reinterpret_cast<void*>(ContinueDebugEvent),
    /* 101 */  reinterpret_cast<void*>(GetProcessList),
    /* 102 */  reinterpret_cast<void*>(GetThreadList),
    /* 103 */  reinterpret_cast<void*>(GetDebugThreadContext),
    /* 104 */  reinterpret_cast<void*>(SetDebugThreadContext),
    /* 105 */  reinterpret_cast<void*>(QueryDebugProcessMemory),
    /* 106 */  reinterpret_cast<void*>(ReadDebugProcessMemory),
    /* 107 */  reinterpret_cast<void*>(WriteDebugProcessMemory),
    /* 108 */  reinterpret_cast<void*>(SetHardwareBreakPoint),
    /* 109 */  reinterpret_cast<void*>(GetDebugThreadParam),
    /* 110 */  NULL,
    /* 111 */  reinterpret_cast<void*>(GetSystemInfo),
    /* 112 */  reinterpret_cast<void*>(CreatePort),
    /* 113 */  reinterpret_cast<void*>(ManageNamedPort),
    /* 114 */  reinterpret_cast<void*>(ConnectToPort),
    /* 115 */  reinterpret_cast<void*>(SetProcessMemoryPermission),
    /* 116 */  reinterpret_cast<void*>(MapProcessMemory),
    /* 117 */  reinterpret_cast<void*>(UnmapProcessMemory),
    /* 118 */  reinterpret_cast<void*>(QueryProcessMemory),
    /* 119 */  reinterpret_cast<void*>(MapProcessCodeMemory),
    /* 120 */  reinterpret_cast<void*>(UnmapProcessCodeMemory),
    /* 121 */  reinterpret_cast<void*>(CreateProcess),
    /* 122 */  reinterpret_cast<void*>(StartProcess),
    /* 123 */  reinterpret_cast<void*>(TerminateProcess),
    /* 124 */  reinterpret_cast<void*>(GetProcessInfo),
    /* 125 */  reinterpret_cast<void*>(CreateResourceLimit),
    /* 126 */  reinterpret_cast<void*>(SetResourceLimitLimitValue),
    /* 127 */  reinterpret_cast<void*>(CallSecureMonitor),
};

} // end of namespace profiler
} // end of namespace ilp32
} // end of namespace aarch64
} // end of namespace svc
} // end of namespace nn

#endif  // ifdef __cplusplus

#ifdef __cplusplus

namespace nn {
namespace svc {
namespace aarch64 {
namespace ilp32 {

void* Intercept(int svcId, void* func)
{
    void* old = nn::svc::aarch64::ilp32::profiler::handlerTable[svcId];
    nn::svc::aarch64::ilp32::profiler::handlerTable[svcId] = func;
    return old;
}

Result SetHeapSize(uintptr_t* pOut, size_t size)
{
    using Type = Result(*)(uintptr_t* pOut, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[1 /* SET_HEAP_SIZE */]);
    return func(pOut, size);
}

Result SetMemoryPermission(uintptr_t addr, size_t size, nn::svc::MemoryPermission permission)
{
    using Type = Result(*)(uintptr_t addr, size_t size, nn::svc::MemoryPermission permission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[2 /* SET_MEMORY_PERMISSION */]);
    return func(addr, size, permission);
}

Result SetMemoryAttribute(uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute)
{
    using Type = Result(*)(uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[3 /* SET_MEMORY_ATTRIBUTE */]);
    return func(addr, size, mask, attribute);
}

Result MapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
{
    using Type = Result(*)(uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[4 /* MAP_MEMORY */]);
    return func(toAddr, fromAddr, size);
}

Result UnmapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
{
    using Type = Result(*)(uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[5 /* UNMAP_MEMORY */]);
    return func(toAddr, fromAddr, size);
}

Result QueryMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr)
{
    using Type = Result(*)(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[6 /* QUERY_MEMORY */]);
    return func(pBlockInfo, pPageInfo, addr);
}

void ExitProcess()
{
    using Type = void(*)();
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[7 /* EXIT_PROCESS */]);
    return func();
}

Result CreateThread(nn::svc::Handle* pOut, nn::svc::lp64::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore)
{
    using Type = Result(*)(nn::svc::Handle* pOut, nn::svc::lp64::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[8 /* CREATE_THREAD */]);
    return func(pOut, f, param, stackBottom, priority, idealCore);
}

Result StartThread(nn::svc::Handle thread)
{
    using Type = Result(*)(nn::svc::Handle thread);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[9 /* START_THREAD */]);
    return func(thread);
}

void ExitThread()
{
    using Type = void(*)();
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[10 /* EXIT_THREAD */]);
    return func();
}

void SleepThread(int64_t ns)
{
    using Type = void(*)(int64_t ns);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[11 /* SLEEP_THREAD */]);
    return func(ns);
}

Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread)
{
    using Type = Result(*)(int32_t* pOut, nn::svc::Handle thread);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[12 /* GET_THREAD_PRIORITY */]);
    return func(pOut, thread);
}

Result SetThreadPriority(nn::svc::Handle thread, int32_t priority)
{
    using Type = Result(*)(nn::svc::Handle thread, int32_t priority);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[13 /* SET_THREAD_PRIORITY */]);
    return func(thread, priority);
}

Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread)
{
    using Type = Result(*)(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[14 /* GET_THREAD_CORE_MASK */]);
    return func(pIdealCore, pAffinityMask, thread);
}

Result SetThreadCoreMask(nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask)
{
    using Type = Result(*)(nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[15 /* SET_THREAD_CORE_MASK */]);
    return func(thread, idealCore, affinityMask);
}

int32_t GetCurrentProcessorNumber()
{
    using Type = int32_t(*)();
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[16 /* GET_CURRENT_PROCESSOR_NUMBER */]);
    return func();
}

Result SignalEvent(nn::svc::Handle event)
{
    using Type = Result(*)(nn::svc::Handle event);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[17 /* SIGNAL_EVENT */]);
    return func(event);
}

Result ClearEvent(nn::svc::Handle event)
{
    using Type = Result(*)(nn::svc::Handle event);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[18 /* CLEAR_EVENT */]);
    return func(event);
}

Result MapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
{
    using Type = Result(*)(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[19 /* MAP_SHARED_MEMORY */]);
    return func(handle, addr, size, myPermission);
}

Result UnmapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
{
    using Type = Result(*)(nn::svc::Handle handle, uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[20 /* UNMAP_SHARED_MEMORY */]);
    return func(handle, addr, size);
}

Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
{
    using Type = Result(*)(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[21 /* CREATE_TRANSFER_MEMORY */]);
    return func(pOut, addr, size, myPermission);
}

Result CloseHandle(nn::svc::Handle handle)
{
    using Type = Result(*)(nn::svc::Handle handle);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[22 /* CLOSE_HANDLE */]);
    return func(handle);
}

Result ResetSignal(nn::svc::Handle handle)
{
    using Type = Result(*)(nn::svc::Handle handle);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[23 /* RESET_SIGNAL */]);
    return func(handle);
}

Result WaitSynchronization(int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns)
{
    using Type = Result(*)(int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[24 /* WAIT_SYNCHRONIZATION */]);
    return func(pOut, handles, numHandles, ns);
}

Result CancelSynchronization(nn::svc::Handle handle)
{
    using Type = Result(*)(nn::svc::Handle handle);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[25 /* CANCEL_SYNCHRONIZATION */]);
    return func(handle);
}

Result ArbitrateLock(nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue)
{
    using Type = Result(*)(nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[26 /* ARBITRATE_LOCK */]);
    return func(handle, addr, ownValue);
}

Result ArbitrateUnlock(uintptr_t addr)
{
    using Type = Result(*)(uintptr_t addr);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[27 /* ARBITRATE_UNLOCK */]);
    return func(addr);
}

Result WaitProcessWideKeyAtomic(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns)
{
    using Type = Result(*)(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[28 /* WAIT_PROCESS_WIDE_KEY_ATOMIC */]);
    return func(addr, cvKey, ownValue, ns);
}

void SignalProcessWideKey(uintptr_t cvKey, int32_t num)
{
    using Type = void(*)(uintptr_t cvKey, int32_t num);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[29 /* SIGNAL_PROCESS_WIDE_KEY */]);
    return func(cvKey, num);
}

int64_t GetSystemTick()
{
    using Type = int64_t(*)();
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[30 /* GET_SYSTEM_TICK */]);
    return func();
}

Result ConnectToNamedPort(nn::svc::Handle* pOut, const char name[])
{
    using Type = Result(*)(nn::svc::Handle* pOut, const char name[]);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[31 /* CONNECT_TO_NAMED_PORT */]);
    return func(pOut, name);
}

Result SendSyncRequestLight(nn::svc::Handle session)
{
    using Type = Result(*)(nn::svc::Handle session);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[32 /* SEND_SYNC_REQUEST_LIGHT */]);
    return func(session);
}

Result SendSyncRequest(nn::svc::Handle session)
{
    using Type = Result(*)(nn::svc::Handle session);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[33 /* SEND_SYNC_REQUEST */]);
    return func(session);
}

Result SendSyncRequestWithUserBuffer(uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
{
    using Type = Result(*)(uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[34 /* SEND_SYNC_REQUEST_WITH_USER_BUFFER */]);
    return func(pMessage, bufferSize, session);
}

Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
{
    using Type = Result(*)(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[35 /* SEND_ASYNC_REQUEST_WITH_USER_BUFFER */]);
    return func(pEvent, pMessage, bufferSize, session);
}

Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process)
{
    using Type = Result(*)(nn::Bit64* pOut, nn::svc::Handle process);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[36 /* GET_PROCESS_ID */]);
    return func(pOut, process);
}

Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread)
{
    using Type = Result(*)(nn::Bit64* pOut, nn::svc::Handle thread);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[37 /* GET_THREAD_ID */]);
    return func(pOut, thread);
}

void Break(nn::svc::BreakReason reason, uintptr_t data, size_t length)
{
    using Type = void(*)(nn::svc::BreakReason reason, uintptr_t data, size_t length);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[38 /* BREAK */]);
    return func(reason, data, length);
}

Result OutputDebugString(const char text[], size_t length)
{
    using Type = Result(*)(const char text[], size_t length);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[39 /* OUTPUT_DEBUG_STRING */]);
    return func(text, length);
}

void ReturnFromException(nn::Result result)
{
    using Type = void(*)(nn::Result result);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[40 /* RETURN_FROM_EXCEPTION */]);
    return func(result);
}

Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param)
{
    using Type = Result(*)(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[41 /* GET_INFO */]);
    return func(pOut, type, handle, param);
}

void FlushEntireDataCache()
{
    using Type = void(*)();
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[42 /* FLUSH_ENTIRE_DATA_CACHE */]);
    return func();
}

Result FlushDataCache(uintptr_t addr, size_t size)
{
    using Type = Result(*)(uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[43 /* FLUSH_DATA_CACHE */]);
    return func(addr, size);
}

Result MapPhysicalMemory(uintptr_t addr, size_t size)
{
    using Type = Result(*)(uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[44 /* MAP_PHYSICAL_MEMORY */]);
    return func(addr, size);
}

Result UnmapPhysicalMemory(uintptr_t addr, size_t size)
{
    using Type = Result(*)(uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[45 /* UNMAP_PHYSICAL_MEMORY */]);
    return func(addr, size);
}

Result GetDebugFutureThreadInfo(nn::svc::lp64::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns)
{
    using Type = Result(*)(nn::svc::lp64::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[46 /* GET_DEBUG_FUTURE_THREAD_INFO */]);
    return func(pContext, threadId, debug, ns);
}

Result GetLastThreadInfo(nn::svc::lp64::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag)
{
    using Type = Result(*)(nn::svc::lp64::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[47 /* GET_LAST_THREAD_INFO */]);
    return func(pContext, pTlsAddr, pFlag);
}

Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
{
    using Type = Result(*)(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[48 /* GET_RESOURCE_LIMIT_LIMIT_VALUE */]);
    return func(value, resourceLimit, resource);
}

Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
{
    using Type = Result(*)(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[49 /* GET_RESOURCE_LIMIT_CURRENT_VALUE */]);
    return func(value, resourceLimit, resource);
}

Result SetThreadActivity(nn::svc::Handle handle, nn::svc::ThreadActivity activity)
{
    using Type = Result(*)(nn::svc::Handle handle, nn::svc::ThreadActivity activity);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[50 /* SET_THREAD_ACTIVITY */]);
    return func(handle, activity);
}

Result GetThreadContext3(nn::svc::ThreadContext* pContext, nn::svc::Handle handle)
{
    using Type = Result(*)(nn::svc::ThreadContext* pContext, nn::svc::Handle handle);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[51 /* GET_THREAD_CONTEXT3 */]);
    return func(pContext, handle);
}

Result WaitForAddress(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns)
{
    using Type = Result(*)(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[52 /* WAIT_FOR_ADDRESS */]);
    return func(addr, type, value, ns);
}

Result SignalToAddress(uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num)
{
    using Type = Result(*)(uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[53 /* SIGNAL_TO_ADDRESS */]);
    return func(addr, type, value, num);
}

void KernelDebug(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2)
{
    using Type = void(*)(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[60 /* KERNEL_DEBUG */]);
    return func(type, param0, param1, param2);
}

void ChangeKernelTraceState(nn::svc::KernelTraceState state)
{
    using Type = void(*)(nn::svc::KernelTraceState state);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[61 /* CHANGE_KERNEL_TRACE_STATE */]);
    return func(state);
}

Result CreateSession(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name)
{
    using Type = Result(*)(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[64 /* CREATE_SESSION */]);
    return func(pServerSession, pClientSession, isLight, name);
}

Result AcceptSession(nn::svc::Handle* pOut, nn::svc::Handle port)
{
    using Type = Result(*)(nn::svc::Handle* pOut, nn::svc::Handle port);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[65 /* ACCEPT_SESSION */]);
    return func(pOut, port);
}

Result ReplyAndReceiveLight(nn::svc::Handle session)
{
    using Type = Result(*)(nn::svc::Handle session);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[66 /* REPLY_AND_RECEIVE_LIGHT */]);
    return func(session);
}

Result ReplyAndReceive(int32_t* pIndex, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
{
    using Type = Result(*)(int32_t* pIndex, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[67 /* REPLY_AND_RECEIVE */]);
    return func(pIndex, pHandles, numHandle, replyTarget, ns);
}

Result ReplyAndReceiveWithUserBuffer(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
{
    using Type = Result(*)(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[68 /* REPLY_AND_RECEIVE_WITH_USER_BUFFER */]);
    return func(pIndex, pMessage, bufferSize, pHandles, numHandle, replyTarget, ns);
}

Result CreateEvent(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle)
{
    using Type = Result(*)(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[69 /* CREATE_EVENT */]);
    return func(pWriteHandle, pReadHandle);
}

Result MapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
{
    using Type = Result(*)(uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[72 /* MAP_PHYSICAL_MEMORY_UNSAFE */]);
    return func(addr, size);
}

Result UnmapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
{
    using Type = Result(*)(uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[73 /* UNMAP_PHYSICAL_MEMORY_UNSAFE */]);
    return func(addr, size);
}

Result SetUnsafeLimit(size_t limitSize)
{
    using Type = Result(*)(size_t limitSize);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[74 /* SET_UNSAFE_LIMIT */]);
    return func(limitSize);
}

Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size)
{
    using Type = Result(*)(nn::svc::Handle* pOut, uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[75 /* CREATE_CODE_MEMORY */]);
    return func(pOut, addr, size);
}

Result ControlCodeMemory(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission)
{
    using Type = Result(*)(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[76 /* CONTROL_CODE_MEMORY */]);
    return func(handle, operation, address, size, permission);
}

void SleepSystem()
{
    using Type = void(*)();
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[77 /* SLEEP_SYSTEM */]);
    return func();
}

Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value)
{
    using Type = Result(*)(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[78 /* READ_WRITE_REGISTER */]);
    return func(pOut, address, mask, value);
}

Result SetProcessActivity(nn::svc::Handle handle, nn::svc::ProcessActivity activity)
{
    using Type = Result(*)(nn::svc::Handle handle, nn::svc::ProcessActivity activity);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[79 /* SET_PROCESS_ACTIVITY */]);
    return func(handle, activity);
}

Result CreateSharedMemory(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission)
{
    using Type = Result(*)(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[80 /* CREATE_SHARED_MEMORY */]);
    return func(pOut, size, myPermission, otherPermission);
}

Result MapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission)
{
    using Type = Result(*)(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[81 /* MAP_TRANSFER_MEMORY */]);
    return func(handle, addr, size, ownerPermission);
}

Result UnmapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
{
    using Type = Result(*)(nn::svc::Handle handle, uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[82 /* UNMAP_TRANSFER_MEMORY */]);
    return func(handle, addr, size);
}

Result CreateInterruptEvent(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type)
{
    using Type = Result(*)(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[83 /* CREATE_INTERRUPT_EVENT */]);
    return func(pReadHandle, name, type);
}

Result QueryPhysicalAddress(nn::svc::lp64::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr)
{
    using Type = Result(*)(nn::svc::lp64::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[84 /* QUERY_PHYSICAL_ADDRESS */]);
    return func(pBlockInfo, addr);
}

Result QueryIoMapping(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size)
{
    using Type = Result(*)(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[85 /* QUERY_IO_MAPPING */]);
    return func(pOut, physicalAddress, size);
}

Result CreateDeviceAddressSpace(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize)
{
    using Type = Result(*)(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[86 /* CREATE_DEVICE_ADDRESS_SPACE */]);
    return func(pOut, spaceAddress, spaceSize);
}

Result AttachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
{
    using Type = Result(*)(nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[87 /* ATTACH_DEVICE_ADDRESS_SPACE */]);
    return func(deviceName, handle);
}

Result DetachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
{
    using Type = Result(*)(nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[88 /* DETACH_DEVICE_ADDRESS_SPACE */]);
    return func(deviceName, handle);
}

Result MapDeviceAddressSpaceByForce(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
{
    using Type = Result(*)(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[89 /* MAP_DEVICE_ADDRESS_SPACE_BY_FORCE */]);
    return func(addressSpace, process, processAddress, size, deviceAddress, devicePermission);
}

Result MapDeviceAddressSpaceAligned(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
{
    using Type = Result(*)(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[90 /* MAP_DEVICE_ADDRESS_SPACE_ALIGNED */]);
    return func(addressSpace, process, processAddress, size, deviceAddress, devicePermission);
}

Result MapDeviceAddressSpace(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
{
    using Type = Result(*)(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[91 /* MAP_DEVICE_ADDRESS_SPACE */]);
    return func(pMappedSize, addressSpace, process, processAddress, size, deviceAddress, devicePermission);
}

Result UnmapDeviceAddressSpace(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress)
{
    using Type = Result(*)(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[92 /* UNMAP_DEVICE_ADDRESS_SPACE */]);
    return func(addressSpace, process, processAddress, size, deviceAddress);
}

Result InvalidateProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
{
    using Type = Result(*)(nn::svc::Handle process, uint64_t addr, uint64_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[93 /* INVALIDATE_PROCESS_DATA_CACHE */]);
    return func(process, addr, size);
}

Result StoreProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
{
    using Type = Result(*)(nn::svc::Handle process, uint64_t addr, uint64_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[94 /* STORE_PROCESS_DATA_CACHE */]);
    return func(process, addr, size);
}

Result FlushProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
{
    using Type = Result(*)(nn::svc::Handle process, uint64_t addr, uint64_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[95 /* FLUSH_PROCESS_DATA_CACHE */]);
    return func(process, addr, size);
}

Result DebugActiveProcess(nn::svc::Handle* pOut, nn::Bit64 processId)
{
    using Type = Result(*)(nn::svc::Handle* pOut, nn::Bit64 processId);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[96 /* DEBUG_ACTIVE_PROCESS */]);
    return func(pOut, processId);
}

Result BreakDebugProcess(nn::svc::Handle debug)
{
    using Type = Result(*)(nn::svc::Handle debug);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[97 /* BREAK_DEBUG_PROCESS */]);
    return func(debug);
}

Result TerminateDebugProcess(nn::svc::Handle debug)
{
    using Type = Result(*)(nn::svc::Handle debug);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[98 /* TERMINATE_DEBUG_PROCESS */]);
    return func(debug);
}

Result GetDebugEvent(nn::svc::lp64::DebugEventInfo* pInfo, nn::svc::Handle debug)
{
    using Type = Result(*)(nn::svc::lp64::DebugEventInfo* pInfo, nn::svc::Handle debug);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[99 /* GET_DEBUG_EVENT */]);
    return func(pInfo, debug);
}

Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::Bit64 pThreadIds[], int32_t arraySize)
{
    using Type = Result(*)(nn::svc::Handle debug, nn::Bit32 flags, const nn::Bit64 pThreadIds[], int32_t arraySize);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[100 /* CONTINUE_DEBUG_EVENT */]);
    return func(debug, flags, pThreadIds, arraySize);
}

Result GetProcessList(int32_t* pNumProcesses, nn::Bit64 pProcessIds[], int32_t arraySize)
{
    using Type = Result(*)(int32_t* pNumProcesses, nn::Bit64 pProcessIds[], int32_t arraySize);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[101 /* GET_PROCESS_LIST */]);
    return func(pNumProcesses, pProcessIds, arraySize);
}

Result GetThreadList(int32_t* pNumThreads, nn::Bit64 pThreadIds[], int32_t arraySize, nn::svc::Handle domain)
{
    using Type = Result(*)(int32_t* pNumThreads, nn::Bit64 pThreadIds[], int32_t arraySize, nn::svc::Handle domain);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[102 /* GET_THREAD_LIST */]);
    return func(pNumThreads, pThreadIds, arraySize, domain);
}

Result GetDebugThreadContext(nn::svc::ThreadContext* pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags)
{
    using Type = Result(*)(nn::svc::ThreadContext* pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[103 /* GET_DEBUG_THREAD_CONTEXT */]);
    return func(pContext, debug, threadId, controlFlags);
}

Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::svc::ThreadContext& context, nn::Bit32 controlFlags)
{
    using Type = Result(*)(nn::svc::Handle debug, nn::Bit64 threadId, const nn::svc::ThreadContext& context, nn::Bit32 controlFlags);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[104 /* SET_DEBUG_THREAD_CONTEXT */]);
    return func(debug, threadId, context, controlFlags);
}

Result QueryDebugProcessMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr)
{
    using Type = Result(*)(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[105 /* QUERY_DEBUG_PROCESS_MEMORY */]);
    return func(pBlockInfo, pPageInfo, process, addr);
}

Result ReadDebugProcessMemory(uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size)
{
    using Type = Result(*)(uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[106 /* READ_DEBUG_PROCESS_MEMORY */]);
    return func(buf, debug, addr, size);
}

Result WriteDebugProcessMemory(nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size)
{
    using Type = Result(*)(nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[107 /* WRITE_DEBUG_PROCESS_MEMORY */]);
    return func(debug, buf, addr, size);
}

Result SetHardwareBreakPoint(nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value)
{
    using Type = Result(*)(nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[108 /* SET_HARDWARE_BREAK_POINT */]);
    return func(regNo, control, value);
}

Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select)
{
    using Type = Result(*)(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[109 /* GET_DEBUG_THREAD_PARAM */]);
    return func(pOut1, pOut2, debug, threadId, select);
}

Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param)
{
    using Type = Result(*)(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[111 /* GET_SYSTEM_INFO */]);
    return func(pOut, type, handle, param);
}

Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name)
{
    using Type = Result(*)(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[112 /* CREATE_PORT */]);
    return func(pOutServer, pOutClient, maxSessions, isLight, name);
}

Result ManageNamedPort(nn::svc::Handle* pOutServer, const char name[], int32_t maxSessions)
{
    using Type = Result(*)(nn::svc::Handle* pOutServer, const char name[], int32_t maxSessions);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[113 /* MANAGE_NAMED_PORT */]);
    return func(pOutServer, name, maxSessions);
}

Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port)
{
    using Type = Result(*)(nn::svc::Handle* pOut, nn::svc::Handle port);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[114 /* CONNECT_TO_PORT */]);
    return func(pOut, port);
}

Result SetProcessMemoryPermission(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission)
{
    using Type = Result(*)(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[115 /* SET_PROCESS_MEMORY_PERMISSION */]);
    return func(process, addr, size, permission);
}

Result MapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
{
    using Type = Result(*)(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[116 /* MAP_PROCESS_MEMORY */]);
    return func(toAddr, process, fromAddr, size);
}

Result UnmapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
{
    using Type = Result(*)(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[117 /* UNMAP_PROCESS_MEMORY */]);
    return func(toAddr, process, fromAddr, size);
}

Result QueryProcessMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr)
{
    using Type = Result(*)(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[118 /* QUERY_PROCESS_MEMORY */]);
    return func(pBlockInfo, pPageInfo, process, addr);
}

Result MapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
{
    using Type = Result(*)(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[119 /* MAP_PROCESS_CODE_MEMORY */]);
    return func(process, toAddr, fromAddr, size);
}

Result UnmapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
{
    using Type = Result(*)(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[120 /* UNMAP_PROCESS_CODE_MEMORY */]);
    return func(process, toAddr, fromAddr, size);
}

Result CreateProcess(nn::svc::Handle* pOut, const nn::svc::lp64::CreateProcessParameter& params, const nn::Bit32 flags[], int32_t flagsNum)
{
    using Type = Result(*)(nn::svc::Handle* pOut, const nn::svc::lp64::CreateProcessParameter& params, const nn::Bit32 flags[], int32_t flagsNum);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[121 /* CREATE_PROCESS */]);
    return func(pOut, params, flags, flagsNum);
}

Result StartProcess(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize)
{
    using Type = Result(*)(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[122 /* START_PROCESS */]);
    return func(runner, priority, coreNo, stackSize);
}

Result TerminateProcess(nn::svc::Handle process)
{
    using Type = Result(*)(nn::svc::Handle process);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[123 /* TERMINATE_PROCESS */]);
    return func(process);
}

Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type)
{
    using Type = Result(*)(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[124 /* GET_PROCESS_INFO */]);
    return func(pOut, handle, type);
}

Result CreateResourceLimit(nn::svc::Handle* pOut)
{
    using Type = Result(*)(nn::svc::Handle* pOut);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[125 /* CREATE_RESOURCE_LIMIT */]);
    return func(pOut);
}

Result SetResourceLimitLimitValue(nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value)
{
    using Type = Result(*)(nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value);
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[126 /* SET_RESOURCE_LIMIT_LIMIT_VALUE */]);
    return func(resourceLimit, resource, value);
}

void CallSecureMonitor()
{
    using Type = void(*)();
    auto func = reinterpret_cast<Type>(nn::svc::aarch64::ilp32::profiler::handlerTable[127 /* CALL_SECURE_MONITOR */]);
    return func();
}

} // end of namespace ilp32
} // end of namespace aarch64
} // end of namespace svc
} // end of namespace nn

#endif  // ifdef __cplusplus
