﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_TcbId.autogen.h>


//-------------------------------------------------
// Result SetUnsafeLimit(size_t limitSize)
//
//     AArch64 s=8 r=8 p=4            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0       4 limitSize   Register 0       8 limitSize
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3214SetUnsafeLimitEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3214SetUnsafeLimitEm
    .hidden  _ZN2nn3svc7aarch645ilp3214SetUnsafeLimitEm
    .type    _ZN2nn3svc7aarch645ilp3214SetUnsafeLimitEm, %function
_ZN2nn3svc7aarch645ilp3214SetUnsafeLimitEm:

    svc      #NN_SVC_ID_SET_UNSAFE_LIMIT
    ret

    .size _ZN2nn3svc7aarch645ilp3214SetUnsafeLimitEm, [.-_ZN2nn3svc7aarch645ilp3214SetUnsafeLimitEm]


//-------------------------------------------------
// void SleepSystem()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211SleepSystemEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211SleepSystemEv
    .hidden  _ZN2nn3svc7aarch645ilp3211SleepSystemEv
    .type    _ZN2nn3svc7aarch645ilp3211SleepSystemEv, %function
_ZN2nn3svc7aarch645ilp3211SleepSystemEv:

    svc      #NN_SVC_ID_SLEEP_SYSTEM
    ret

    .size _ZN2nn3svc7aarch645ilp3211SleepSystemEv, [.-_ZN2nn3svc7aarch645ilp3211SleepSystemEv]


//-------------------------------------------------
// Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch645ilp3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy
    .type    _ZN2nn3svc7aarch645ilp3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy, %function
_ZN2nn3svc7aarch645ilp3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_SYSTEM_INFO

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy, [.-_ZN2nn3svc7aarch645ilp3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy]


//-------------------------------------------------
// Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name)
//
//     AArch64 s=8 r=8 p=4              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pOutServer    
//     Register 1  ref  4 pOutClient    
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//     Register 3       1 isLight       Register 3       1 isLight
//     Register 4       4 name          Register 4       8 name
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOutServer
//                                      Register 2       4 pOutClient
//
// conversion
//   Scatter         pOutServer
//   Scatter         pOutClient

    .section .text._ZN2nn3svc7aarch645ilp3210CreatePortEPNS0_6HandleES4_ibm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3210CreatePortEPNS0_6HandleES4_ibm
    .hidden  _ZN2nn3svc7aarch645ilp3210CreatePortEPNS0_6HandleES4_ibm
    .type    _ZN2nn3svc7aarch645ilp3210CreatePortEPNS0_6HandleES4_ibm, %function
_ZN2nn3svc7aarch645ilp3210CreatePortEPNS0_6HandleES4_ibm:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_PORT

    ldr      x3, [sp, #0]              // pOutServerのアドレス をスタックからレジスタへ
    str      w1, [x3, #0]              // pOutServer の第 1 ワードをレジスタからメモリへ
    ldr      x3, [sp, #8]              // pOutClientのアドレス をスタックからレジスタへ
    str      w2, [x3, #0]              // pOutClient の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3210CreatePortEPNS0_6HandleES4_ibm, [.-_ZN2nn3svc7aarch645ilp3210CreatePortEPNS0_6HandleES4_ibm]


//-------------------------------------------------
// Result ManageNamedPort(nn::svc::Handle* pOutServer, const char name[], int32_t maxSessions)
//
//     AArch64 s=8 r=8 p=4              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pOutServer    
//     Register 1  ref -- name          Register 1  ref -- name
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOutServer
//
// conversion
//   Scatter         pOutServer

    .section .text._ZN2nn3svc7aarch645ilp3215ManageNamedPortEPNS0_6HandleEPKci, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3215ManageNamedPortEPNS0_6HandleEPKci
    .hidden  _ZN2nn3svc7aarch645ilp3215ManageNamedPortEPNS0_6HandleEPKci
    .type    _ZN2nn3svc7aarch645ilp3215ManageNamedPortEPNS0_6HandleEPKci, %function
_ZN2nn3svc7aarch645ilp3215ManageNamedPortEPNS0_6HandleEPKci:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_MANAGE_NAMED_PORT

    ldr      x2, [sp, #0]              // pOutServerのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOutServer の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3215ManageNamedPortEPNS0_6HandleEPKci, [.-_ZN2nn3svc7aarch645ilp3215ManageNamedPortEPNS0_6HandleEPKci]


//-------------------------------------------------
// Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 port     Register 1       4 port
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3213ConnectToPortEPNS0_6HandleES3_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213ConnectToPortEPNS0_6HandleES3_
    .hidden  _ZN2nn3svc7aarch645ilp3213ConnectToPortEPNS0_6HandleES3_
    .type    _ZN2nn3svc7aarch645ilp3213ConnectToPortEPNS0_6HandleES3_, %function
_ZN2nn3svc7aarch645ilp3213ConnectToPortEPNS0_6HandleES3_:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CONNECT_TO_PORT

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3213ConnectToPortEPNS0_6HandleES3_, [.-_ZN2nn3svc7aarch645ilp3213ConnectToPortEPNS0_6HandleES3_]


//-------------------------------------------------
// Result SetProcessMemoryPermission(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 process      Register 0       4 process
//     Register 1       8 addr         Register 1       8 addr
//     Register 2       8 size         Register 2       8 size
//     Register 3       4 permission   Register 3       4 permission
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_SET_PROCESS_MEMORY_PERMISSION
    ret

    .size _ZN2nn3svc7aarch645ilp3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result MapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       4 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3216MapProcessMemoryEmNS0_6HandleEym, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3216MapProcessMemoryEmNS0_6HandleEym
    .hidden  _ZN2nn3svc7aarch645ilp3216MapProcessMemoryEmNS0_6HandleEym
    .type    _ZN2nn3svc7aarch645ilp3216MapProcessMemoryEmNS0_6HandleEym, %function
_ZN2nn3svc7aarch645ilp3216MapProcessMemoryEmNS0_6HandleEym:

    svc      #NN_SVC_ID_MAP_PROCESS_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3216MapProcessMemoryEmNS0_6HandleEym, [.-_ZN2nn3svc7aarch645ilp3216MapProcessMemoryEmNS0_6HandleEym]


//-------------------------------------------------
// Result UnmapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       4 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3218UnmapProcessMemoryEmNS0_6HandleEym, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3218UnmapProcessMemoryEmNS0_6HandleEym
    .hidden  _ZN2nn3svc7aarch645ilp3218UnmapProcessMemoryEmNS0_6HandleEym
    .type    _ZN2nn3svc7aarch645ilp3218UnmapProcessMemoryEmNS0_6HandleEym, %function
_ZN2nn3svc7aarch645ilp3218UnmapProcessMemoryEmNS0_6HandleEym:

    svc      #NN_SVC_ID_UNMAP_PROCESS_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3218UnmapProcessMemoryEmNS0_6HandleEym, [.-_ZN2nn3svc7aarch645ilp3218UnmapProcessMemoryEmNS0_6HandleEym]


//-------------------------------------------------
// Result QueryProcessMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    
//     Register 2       4 process      Register 2       4 process
//     Register 3       8 addr         Register 3       8 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch645ilp3218QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3218QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch645ilp3218QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEy
    .type    _ZN2nn3svc7aarch645ilp3218QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEy, %function
_ZN2nn3svc7aarch645ilp3218QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEy:

    str      x1, [sp, #-16]!

    svc      #NN_SVC_ID_QUERY_PROCESS_MEMORY

    ldr      x2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3218QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEy, [.-_ZN2nn3svc7aarch645ilp3218QueryProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEy]


//-------------------------------------------------
// Result MapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 toAddr     Register 1       8 toAddr
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3220MapProcessCodeMemoryENS0_6HandleEyyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3220MapProcessCodeMemoryENS0_6HandleEyyy
    .hidden  _ZN2nn3svc7aarch645ilp3220MapProcessCodeMemoryENS0_6HandleEyyy
    .type    _ZN2nn3svc7aarch645ilp3220MapProcessCodeMemoryENS0_6HandleEyyy, %function
_ZN2nn3svc7aarch645ilp3220MapProcessCodeMemoryENS0_6HandleEyyy:

    svc      #NN_SVC_ID_MAP_PROCESS_CODE_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3220MapProcessCodeMemoryENS0_6HandleEyyy, [.-_ZN2nn3svc7aarch645ilp3220MapProcessCodeMemoryENS0_6HandleEyyy]


//-------------------------------------------------
// Result UnmapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 toAddr     Register 1       8 toAddr
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 size       Register 3       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3222UnmapProcessCodeMemoryENS0_6HandleEyyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3222UnmapProcessCodeMemoryENS0_6HandleEyyy
    .hidden  _ZN2nn3svc7aarch645ilp3222UnmapProcessCodeMemoryENS0_6HandleEyyy
    .type    _ZN2nn3svc7aarch645ilp3222UnmapProcessCodeMemoryENS0_6HandleEyyy, %function
_ZN2nn3svc7aarch645ilp3222UnmapProcessCodeMemoryENS0_6HandleEyyy:

    svc      #NN_SVC_ID_UNMAP_PROCESS_CODE_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3222UnmapProcessCodeMemoryENS0_6HandleEyyy, [.-_ZN2nn3svc7aarch645ilp3222UnmapProcessCodeMemoryENS0_6HandleEyyy]


//-------------------------------------------------
// Result CreateProcess(nn::svc::Handle* pOut, const nn::svc::lp64::CreateProcessParameter& params, const nn::Bit32 flags[], int32_t flagsNum)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0  ref  4 pOut       
//     Register 1  ref 48 params     Register 1  ref 48 params
//     Register 2  ref -- flags      Register 2  ref -- flags
//     Register 3       4 flagsNum   Register 3       4 flagsNum
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3213CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji
    .hidden  _ZN2nn3svc7aarch645ilp3213CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji
    .type    _ZN2nn3svc7aarch645ilp3213CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji, %function
_ZN2nn3svc7aarch645ilp3213CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_PROCESS

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3213CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji, [.-_ZN2nn3svc7aarch645ilp3213CreateProcessEPNS0_6HandleERKNS0_4lp6422CreateProcessParameterEPKji]


//-------------------------------------------------
// Result StartProcess(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize)
//
//     AArch64 s=8 r=8 p=4            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0       4 runner      Register 0       4 runner
//     Register 1       4 priority    Register 1       4 priority
//     Register 2       4 coreNo      Register 2       4 coreNo
//     Register 3       8 stackSize   Register 3       8 stackSize
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3212StartProcessENS0_6HandleEiiy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3212StartProcessENS0_6HandleEiiy
    .hidden  _ZN2nn3svc7aarch645ilp3212StartProcessENS0_6HandleEiiy
    .type    _ZN2nn3svc7aarch645ilp3212StartProcessENS0_6HandleEiiy, %function
_ZN2nn3svc7aarch645ilp3212StartProcessENS0_6HandleEiiy:

    svc      #NN_SVC_ID_START_PROCESS
    ret

    .size _ZN2nn3svc7aarch645ilp3212StartProcessENS0_6HandleEiiy, [.-_ZN2nn3svc7aarch645ilp3212StartProcessENS0_6HandleEiiy]


//-------------------------------------------------
// Result TerminateProcess(nn::svc::Handle process)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3216TerminateProcessENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3216TerminateProcessENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3216TerminateProcessENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3216TerminateProcessENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3216TerminateProcessENS0_6HandleE:

    svc      #NN_SVC_ID_TERMINATE_PROCESS
    ret

    .size _ZN2nn3svc7aarch645ilp3216TerminateProcessENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3216TerminateProcessENS0_6HandleE]


//-------------------------------------------------
// Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 handle   Register 1       4 handle
//     Register 2       4 type     Register 2       4 type
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE
    .hidden  _ZN2nn3svc7aarch645ilp3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE
    .type    _ZN2nn3svc7aarch645ilp3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE, %function
_ZN2nn3svc7aarch645ilp3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_PROCESS_INFO

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE, [.-_ZN2nn3svc7aarch645ilp3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE]


//-------------------------------------------------
// Result CreateResourceLimit(nn::svc::Handle* pOut)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3219CreateResourceLimitEPNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3219CreateResourceLimitEPNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3219CreateResourceLimitEPNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3219CreateResourceLimitEPNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3219CreateResourceLimitEPNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_RESOURCE_LIMIT

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3219CreateResourceLimitEPNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3219CreateResourceLimitEPNS0_6HandleE]


//-------------------------------------------------
// Result SetResourceLimitLimitValue(nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0       4 resourceLimit   Register 0       4 resourceLimit
//     Register 1       4 resource        Register 1       4 resource
//     Register 2       8 value           Register 2       8 value
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx
    .hidden  _ZN2nn3svc7aarch645ilp3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx
    .type    _ZN2nn3svc7aarch645ilp3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx, %function
_ZN2nn3svc7aarch645ilp3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx:

    svc      #NN_SVC_ID_SET_RESOURCE_LIMIT_LIMIT_VALUE
    ret

    .size _ZN2nn3svc7aarch645ilp3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx, [.-_ZN2nn3svc7aarch645ilp3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx]


//-------------------------------------------------
// void CallSecureMonitor()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217CallSecureMonitorEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217CallSecureMonitorEv
    .hidden  _ZN2nn3svc7aarch645ilp3217CallSecureMonitorEv
    .type    _ZN2nn3svc7aarch645ilp3217CallSecureMonitorEv, %function
_ZN2nn3svc7aarch645ilp3217CallSecureMonitorEv:

    svc      #NN_SVC_ID_CALL_SECURE_MONITOR
    ret

    .size _ZN2nn3svc7aarch645ilp3217CallSecureMonitorEv, [.-_ZN2nn3svc7aarch645ilp3217CallSecureMonitorEv]


    .end

