﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>

#include <nn/TargetConfigs/build_Cpu.h>

#include "spl_SecureMonitorCall.h"

#if defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_CLANG)
    #if defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
        #if defined(NN_BUILD_CONFIG_CPU_ARM64)
            #define SECURE_MONITOR_ENABLED
        #endif
    #endif
#endif


namespace nn { namespace spl { namespace smc {

#if defined(SECURE_MONITOR_ENABLED)
    __attribute__((naked)) void CallSecureMonitor(Registers* p)
    {
        asm volatile(
            "   stp     x0, x1, [sp, #-0x10]!   \n"
            "   mov     x8, x0                  \n"

            "   ldp     x0, x1, [x8,#0x00]      \n"
            "   ldp     x2, x3, [x8,#0x10]      \n"
            "   ldp     x4, x5, [x8,#0x20]      \n"
            "   ldp     x6, x7, [x8,#0x30]      \n"

            "   svc     0x7f                    \n"

            "   ldr     x8, [sp]                \n"

            "   stp     x0, x1, [x8,#0x00]      \n"
            "   stp     x2, x3, [x8,#0x10]      \n"
            "   stp     x4, x5, [x8,#0x20]      \n"
            "   stp     x6, x7, [x8,#0x30]      \n"

            "   add     sp, sp, #0x10           \n"
            "   ret                             \n"
        );
    }
#else
    void CallSecureMonitor(Registers* p)
    {
        NN_UNUSED(p);
        NN_SDK_LOG("[spl] SecureMonitor is not available.\n");
    }
#endif


}}}  // namespace nn::spl::smc

