﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdarg>
#include <nn/os.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_ApiPrivate.h>    // for MMsgHdr
#include <nn/socket/socket_Errno.h>
#include <nn/socket/socket_Types.h>
#include "detail/socket_Api.h"


namespace nn     {
namespace socket {

ssize_t Recv(int socket, void* outBuffer, size_t outBufferLength, MsgFlag flags)
NN_NOEXCEPT
{
    return detail::Recv(socket, outBuffer, outBufferLength, flags);
}

ssize_t Recv(int socket, void* outBuffer, size_t outBufferLength, int flags)
NN_NOEXCEPT
{
    return detail::Recv(socket, outBuffer, outBufferLength, flags);
}

ssize_t RecvFrom(int socket, void* outBuffer, size_t outBufferLength, MsgFlag flags, SockAddr* pOutAddress, SockLenT* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::RecvFrom(socket, outBuffer, outBufferLength, flags, pOutAddress, pOutAddressLength);
}

ssize_t RecvFrom(int socket, void* outBuffer, size_t outBufferLength, int flags, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::RecvFrom(socket, outBuffer, outBufferLength, flags, pOutAddress, pOutAddressLength);
}

ssize_t Send(int socket, const void* buffer, size_t bufferLength, MsgFlag flags)
NN_NOEXCEPT
{
    return detail::Send(socket, buffer, bufferLength, flags);
}

ssize_t Send(int socket, const void* buffer, size_t bufferLength, int flags)
NN_NOEXCEPT
{
    return detail::Send(socket, buffer, bufferLength, flags);
}

ssize_t SendTo(int socket, const void* buffer, size_t bufferLength, MsgFlag flags, const SockAddr* pAddress, SockLenT addressLength)
NN_NOEXCEPT
{
    return detail::SendTo(socket, buffer, bufferLength, flags, pAddress, addressLength);
}

ssize_t SendTo(int socket, const void* buffer, size_t bufferLength, int flags, const sockaddr* pAddress, socklen_t addressLength)
NN_NOEXCEPT
{
    return detail::SendTo(socket, buffer, bufferLength, flags, pAddress, addressLength);
}

int Accept(int socket, SockAddr* pOutAddress, SockLenT* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::Accept(socket, pOutAddress, pOutAddressLength);
}

int Accept(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::Accept(socket, pOutAddress, pOutAddressLength);
}

int Bind(int socket, const SockAddr* pAddress, SockLenT addressLength)
NN_NOEXCEPT
{
    return detail::Bind(socket, pAddress, addressLength);
}

int Bind(int socket, const sockaddr* pAddress, socklen_t addressLength)
NN_NOEXCEPT
{
    return detail::Bind(socket, pAddress, addressLength);
}

int Connect(int socket, const SockAddr* pAddress, SockLenT addressLength)
NN_NOEXCEPT
{
    return detail::Connect(socket, pAddress, addressLength);
}

int Connect(int socket, const sockaddr* pAddress, socklen_t addressLength)
NN_NOEXCEPT
{
    return detail::Connect(socket, pAddress, addressLength);
}

int GetPeerName(int socket, SockAddr* pOutAddress, SockLenT* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::GetPeerName(socket, pOutAddress, pOutAddressLength);
}

int GetPeerName(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::GetPeerName(socket, pOutAddress, pOutAddressLength);
}

int GetSockName(int socket, SockAddr* pOutAddress, SockLenT* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::GetSockName(socket, pOutAddress, pOutAddressLength);
}

int GetSockName(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
NN_NOEXCEPT
{
    return detail::GetSockName(socket, pOutAddress, pOutAddressLength);
}

int GetSockOpt(int socket, Level level, Option optionName, void* pOutOptionValue, SockLenT* pOutOptionLength)
NN_NOEXCEPT
{
    return detail::GetSockOpt(socket, level, optionName, pOutOptionValue, pOutOptionLength);
}

int GetSockOpt(int socket, int level, int optionName, void* pOutOptionValue, socklen_t* pOutOptionLength)
NN_NOEXCEPT
{
    return detail::GetSockOpt(socket, level, optionName, pOutOptionValue, pOutOptionLength);
}

int Listen(int socket, int backlog)
NN_NOEXCEPT
{
    return detail::Listen(socket, backlog);
}

int SetSockOpt(int socket, Level level, Option optionName, const void* pOptionValue, SockLenT optionLength)
NN_NOEXCEPT
{
    return detail::SetSockOpt(socket, level, optionName, pOptionValue, optionLength);
}

int SetSockOpt(int socket, int level, int optionName, const void* pOptionValue, socklen_t optionLength)
NN_NOEXCEPT
{
    return detail::SetSockOpt(socket, level, optionName, pOptionValue, optionLength);
}

int SockAtMark(int socket)
NN_NOEXCEPT
{
    return detail::SockAtMark(socket);
}

int Shutdown(int socket, ShutdownMethod how)
NN_NOEXCEPT
{
    return detail::Shutdown(socket, how);
}

int Shutdown(int socket, int how)
NN_NOEXCEPT
{
    return detail::Shutdown(socket, how);
}

int ShutdownAllSockets(bool forced)
NN_NOEXCEPT
{
    return detail::ShutdownAllSockets(forced);
}

int Socket(Family domain, Type type, Protocol protocol)
NN_NOEXCEPT
{
    return detail::Socket(domain, type, protocol);
}

int Socket(int domain, int type, int protocol)
NN_NOEXCEPT
{
    return detail::Socket(domain, type, protocol);
}

int SocketExempt(Family domain, Type type, Protocol protocol)
NN_NOEXCEPT
{
    return detail::SocketExempt(domain, type, protocol);
}

int SocketExempt(int domain, int type, int protocol)
NN_NOEXCEPT
{
    return detail::SocketExempt(domain, type, protocol);
}

int Write(int socket, const void* buffer, size_t bufferLength)
NN_NOEXCEPT
{
    return detail::Write(socket, buffer, bufferLength);
}

int Read(int socket, void* outBuffer, size_t outBufferLength)
NN_NOEXCEPT
{
    return detail::Read(socket, outBuffer, outBufferLength);
}

int Close(int socket)
NN_NOEXCEPT
{
    return detail::Close(socket);
}

int Select(int numberOfDescriptors, FdSet* pReadDescriptors, FdSet* pWriteDescriptors, FdSet* pExceptDescriptors, TimeVal* pTimeout)
NN_NOEXCEPT
{
    return detail::Select(numberOfDescriptors, pReadDescriptors, pWriteDescriptors, pExceptDescriptors, pTimeout);
}

int Select(int numberOfDescriptors, fd_set* pReadDescriptors, fd_set* pWriteDescriptors, fd_set* pExceptDescriptors, timeval* pTimeout)
NN_NOEXCEPT
{
    return detail::Select(numberOfDescriptors, pReadDescriptors, pWriteDescriptors, pExceptDescriptors, pTimeout);
}

int Poll(PollFd* pSocketDescriptors, NfdsT numberOfDescriptors, int timeoutMilliseconds)
NN_NOEXCEPT
{
    return detail::Poll(pSocketDescriptors, numberOfDescriptors, timeoutMilliseconds);
}

int Poll(pollfd* pSocketDescriptors, nfds_t numberOfDescriptors, int timeoutMilliseconds)
NN_NOEXCEPT
{
    return detail::Poll(pSocketDescriptors, numberOfDescriptors, timeoutMilliseconds);
}

int Fcntl(int socket, FcntlCommand command, ...)
NN_NOEXCEPT
{
    int iocmd;
    va_list args;
    va_start(args, command);
    iocmd = va_arg(args, int);
    va_end(args);
    return detail::Fcntl(socket, command, iocmd);
}

int Fcntl(int socket, int command, ...)
NN_NOEXCEPT
{
    int iocmd;
    va_list args;
    va_start(args, command);
    iocmd = va_arg(args, int);
    va_end(args);
    return detail::Fcntl(socket, command, iocmd);
}

int InetPton(Family family, const char* pAddressString, void* pOutAddressBuffer)
NN_NOEXCEPT
{
    return detail::InetPton(family, pAddressString, pOutAddressBuffer);
}

int InetPton(int family, const char* pAddressString, void* pOutAddressBuffer)
NN_NOEXCEPT
{
    return detail::InetPton(family, pAddressString, pOutAddressBuffer);
}

const char* InetNtop(Family family, const void* pNetworkAddress, char* addressStringBuffer, SockLenT addressStringBufferLength)
NN_NOEXCEPT
{
    return detail::InetNtop(family, pNetworkAddress, addressStringBuffer, addressStringBufferLength);
}

const char* InetNtop(int family, const void* pNetworkAddress, char* addressStringBuffer, socklen_t addressStringBufferLength)
NN_NOEXCEPT
{
    return detail::InetNtop(family, pNetworkAddress, addressStringBuffer, addressStringBufferLength);
}

int InetAton(const char* addressStringBuffer, InAddr* pOutNetworkAddress)
NN_NOEXCEPT
{
    return detail::InetAton(addressStringBuffer, pOutNetworkAddress);
}

int InetAton(const char* addressStringBuffer, in_addr* pOutNetworkAddress)
NN_NOEXCEPT
{
    return detail::InetAton(addressStringBuffer, pOutNetworkAddress);
}

char* InetNtoa(InAddr networkAddress)
NN_NOEXCEPT
{
    return detail::InetNtoa(networkAddress);
}

char* InetNtoa(in_addr networkAddress)
NN_NOEXCEPT
{
    return detail::InetNtoa(networkAddress);
}

uint16_t InetHtons(uint16_t hostValue)
NN_NOEXCEPT
{
    return detail::InetHtons(hostValue);
}

uint32_t InetHtonl(uint32_t hostValue)
NN_NOEXCEPT
{
    return detail::InetHtonl(hostValue);
}

uint16_t InetNtohs(uint16_t networkValue)
NN_NOEXCEPT
{
    return detail::InetNtohs(networkValue);
}

uint32_t InetNtohl(uint32_t networkValue)
NN_NOEXCEPT
{
    return detail::InetNtohl(networkValue);
}

Errno GetLastError()
NN_NOEXCEPT
{
    return detail::GetLastError();
}

int GetLastErrno()
NN_NOEXCEPT
{
    return detail::GetLastErrno();
}

void SetLastError(Errno error)
NN_NOEXCEPT
{
    nn::socket::detail::SetLastError(error);
}

void SetLastErrno(int error)
NN_NOEXCEPT
{
    detail::SetLastErrno(error);
}

ssize_t RecvMsg(int socket, MsgHdr* pOutMessage, MsgFlag flags)
NN_NOEXCEPT
{
    return detail::RecvMsg(socket, pOutMessage, flags);
}

ssize_t RecvMsg(int socket, msghdr* pOutMessage, int flags)
NN_NOEXCEPT
{
    return detail::RecvMsg(socket, pOutMessage, flags);
}

ssize_t RecvMMsg(int socket, MMsgHdr* pMsgvec, size_t vlen, MsgFlag flags, nn::TimeSpan *pTimeout)
NN_NOEXCEPT
{
    return detail::RecvMMsg(socket, pMsgvec, vlen, flags, pTimeout);
}

ssize_t RecvMMsg(int socket, mmsghdr* pMsgvec, size_t vlen, int flags, nn::TimeSpan *pTimeout)
NN_NOEXCEPT
{
    return detail::RecvMMsg(socket, pMsgvec, vlen, flags, pTimeout);
}

ssize_t SendMsg(int socket, const MsgHdr* pMessage, MsgFlag flags)
NN_NOEXCEPT
{
    return detail::SendMsg(socket, pMessage, flags);
}

ssize_t SendMsg(int socket, const msghdr* pMessage, int flags)
NN_NOEXCEPT
{
    return detail::SendMsg(socket, pMessage, flags);
}

ssize_t SendMMsg(int socket, const MMsgHdr* pMsgvec, size_t vlen, MsgFlag flags)
NN_NOEXCEPT
{
    return detail::SendMMsg(socket, pMsgvec, vlen, flags);
}

ssize_t SendMMsg(int socket, const mmsghdr* pMsgvec, size_t vlen, int flags)
NN_NOEXCEPT
{
    return detail::SendMMsg(socket, pMsgvec, vlen, flags);
}

int Ioctl(int fd, IoctlCommand command, void* pData, size_t dataLength)
NN_NOEXCEPT
{
    return detail::Ioctl(fd, command, pData, dataLength);
}

int Ioctl(int fd, uint32_t command, void* pData, size_t dataLength)
NN_NOEXCEPT
{
    return detail::Ioctl(fd, command, pData, dataLength);
}

int Open(const char* path, OpenFlag flags)
NN_NOEXCEPT
{
    return detail::Open(path, flags);
}

int Open(const char* path, int flags)
NN_NOEXCEPT
{
    return detail::Open(path, flags);
}

Result Initialize(void* memoryPool, size_t memoryPoolSize, size_t allocatorPoolSize, int concurrencyLimit)
NN_NOEXCEPT
{
    return detail::Initialize(memoryPool, memoryPoolSize, allocatorPoolSize, concurrencyLimit);
}

Result Initialize(const nn::socket::Config& config)
NN_NOEXCEPT
{
    return detail::Initialize(config);
}

Result Finalize()
NN_NOEXCEPT
{
    return detail::Finalize();
}

AiErrno GetAddrInfo(const char* pNodeName, const char* pServerName, const AddrInfo* pHints, AddrInfo** pResult)
NN_NOEXCEPT
{
    return detail::GetAddrInfo(pNodeName, pServerName, pHints, pResult, nullptr, 0);
}

int GetAddrInfo(const char* pNodeName, const char* pServerName, const addrinfo* pHints, addrinfo** pResult)
NN_NOEXCEPT
{
    return detail::GetAddrInfo(pNodeName, pServerName, pHints, pResult, nullptr, 0);
}

AiErrno GetAddrInfo(const char* pNodeName, const char* pServerName, const AddrInfo* pHints, AddrInfo** pResult, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetAddrInfo(pNodeName, pServerName, pHints, pResult, options, optionsCount);
}

int GetAddrInfo(const char* pNodeName, const char* pServerName, const addrinfo* pHints, addrinfo** pResult, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetAddrInfo(pNodeName, pServerName, pHints, pResult, options, optionsCount);
}

void FreeAddrInfo(AddrInfo* addrInfoStorage)
NN_NOEXCEPT
{
    detail::FreeAddrInfo(addrInfoStorage);
}

void FreeAddrInfo(addrinfo* addrInfoStorage)
NN_NOEXCEPT
{
    detail::FreeAddrInfo(addrInfoStorage);
}

AiErrno GetNameInfo(const SockAddr* socketAddress, SockLenT socketAddressLength, char* host, size_t hostLength, char* service, size_t serviceLength, NameInfoFlag flags)
NN_NOEXCEPT
{
    return detail::GetNameInfo(socketAddress, socketAddressLength, host, hostLength, service, serviceLength, flags, static_cast<nn::socket::ResolverOption*>(nullptr), static_cast<size_t>(0));
}

int GetNameInfo(const sockaddr* socketAddress, socklen_t socketAddressLength, char* host, socklen_t hostLength, char* service, socklen_t serviceLength, int flags)
NN_NOEXCEPT
{
    return detail::GetNameInfo(socketAddress, socketAddressLength, host, hostLength, service, serviceLength, flags, nullptr, 0);
}

AiErrno GetNameInfo(const SockAddr* socketAddress, SockLenT socketAddressLength, char* host, size_t hostLength, char* service, size_t serviceLength, NameInfoFlag flags, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetNameInfo(socketAddress, socketAddressLength, host, hostLength, service, serviceLength, flags, options, optionsCount);
}

int GetNameInfo(const sockaddr* socketAddress, socklen_t socketAddressLength, char* host, socklen_t hostLength, char* service, socklen_t serviceLength, int flags, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetNameInfo(socketAddress, socketAddressLength, host, hostLength, service, serviceLength, flags, options, optionsCount);
}

HostEnt* GetHostEntByName(const char* pName)
NN_NOEXCEPT
{
    return detail::GetHostEntByName(pName, nullptr, 0);
}

hostent* GetHostByName(const char* pName)
NN_NOEXCEPT
{
    return detail::GetHostByName(pName, nullptr, 0);
}

HostEnt* GetHostEntByName(const char* pName, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetHostEntByName(pName, options, optionsCount);
}

hostent* GetHostByName(const char* pName, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetHostByName(pName, options, optionsCount);
}

HostEnt* GetHostEntByAddr(const void* pAddress, SockLenT length, Family addressFamily)
NN_NOEXCEPT
{
    return detail::GetHostEntByAddr(pAddress, length, addressFamily, nullptr, 0);
}

hostent* GetHostByAddr(const void* pAddress, socklen_t length, int addressFamily)
NN_NOEXCEPT
{
    return detail::GetHostByAddr(pAddress, length, addressFamily, nullptr, 0);
}

HostEnt* GetHostEntByAddr(const void* pAddress, SockLenT length, Family addressFamily, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetHostEntByAddr(pAddress, length, addressFamily, options, optionsCount);
}

hostent* GetHostByAddr(const void* pAddress, socklen_t length, int addressFamily, const nn::socket::ResolverOption* options, size_t optionsCount)
NN_NOEXCEPT
{
    return detail::GetHostByAddr(pAddress, length, addressFamily, options, optionsCount);
}

HErrno* GetHError()
NN_NOEXCEPT
{
    return detail::GetHError();
}

int* GetHErrno()
NN_NOEXCEPT
{
    return detail::GetHErrno();
}

const char* HStrError(HErrno errorNumber)
NN_NOEXCEPT
{
    return detail::HStrError(errorNumber);
}

const char* HStrError(int errorNumber)
NN_NOEXCEPT
{
    return detail::HStrError(errorNumber);
}

const char* GAIStrError(AiErrno errorCode)
NN_NOEXCEPT
{
    return detail::GAIStrError(errorCode);
}

const char* GAIStrError(int errorCode)
NN_NOEXCEPT
{
    return detail::GAIStrError(errorCode);
}

int ResolverGetOption(ResolverOption* pOptionOut, ResolverOptionKey key)
NN_NOEXCEPT
{
    return detail::ResolverGetOption(pOptionOut, static_cast<uint32_t>(key));
};

int ResolverSetOption(const ResolverOption& option)
NN_NOEXCEPT
{
    return detail::ResolverSetOption(option);
};

int Sysctl(int* pMibEntries, size_t mibEntryCount, void* pOldValue, size_t* pOldValueLength, void* pNewValue, size_t newValueLength)
NN_NOEXCEPT
{
    return detail::Sysctl(pMibEntries, mibEntryCount, pOldValue, pOldValueLength, pNewValue, newValueLength);
}

int DuplicateSocket(int socket, uint64_t ProcessId)
NN_NOEXCEPT
{
    return detail::DuplicateSocket(socket, ProcessId);
}

int GetResourceStatistics(StatisticsType type, void* outBuffer, size_t outBufferLength, uint32_t options)
NN_NOEXCEPT
{
    return detail::GetResourceStatistics(type, outBuffer, outBufferLength, options);
}


}} /* nn::socket */
