﻿// Definitions file for the resolver interface.
// Written in C#.

// It is convenient to describe a directory called "using," as shown below.
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.socket.resolver
{
   [CppRefPath(@"<nn/socket/resolver/sfdl/resolver.sfdl.h>")]
    public interface IResolver : IServiceObject
    {
        // --------------------------------------------------------------------
        // MethodId 0 & 1 These methods were private API functions that were
        // replaced in SIGLONTD-10334/SIGLO-58527 with private ResolverOptions.
        // The methods must live on to support games mastered against older
        // versions but simply return success.
        // --------------------------------------------------------------------

        // private sf method to set dns addresses
        [MethodId(0)]
            Result SetDnsAddressesPrivateRequest(
                nn.sf.InBuffer sockaddrArray,
                uint32_t length);

        // private sf method to set get a dns serve address
        [MethodId(1)]
            Result GetDnsAddressPrivateRequest(
                uint32_t n,
                nn.sf.OutBuffer socketAddressOut);

        // --------------------------------------------------------------------
        // MethodId 2, 3, 6, & 7 define function signatures in use in the public
        // API prior to version 4.x, before ResolverOptions was in the public
        // SDK (in SIGLONTD-11143 / SIGLO-58485), and pre-DNS
        // (in SIGLONTD-10334 / SIGLO-58527); they provide compatibility for
        // games mastered against earlier versions of the socket library but
        // in the server they make use of the newer methods defined below.
        // --------------------------------------------------------------------

        // deprecated
        [MethodId(2)]
            Result GetHostByNameRequest(
                uint32_t cancelHandle,
                [ProcessId] nn.Bit64 pid,
                bool useNsdResolve,
                nn.sf.InBuffer name,
                Out<uint32_t> hostErrorOut,
                Out<uint32_t> errnoOut,
                nn.sf.OutBuffer serializedHostentResponse,
                Out<uint32_t> bufferLengthOut);

        // deprecated
        [MethodId(3)]
            Result GetHostByAddrRequest(
                uint32_t cancelHandle,
                [ProcessId] nn.Bit64 pid,
                nn.sf.InBuffer serializedInAddrIn,
                uint32_t serializedInAddrLengthIn,
                uint32_t addressFamilyIn,
                Out<uint32_t> hostErrorOut,
                Out<uint32_t> errnoOut,
                nn.sf.OutBuffer serializedHostentResponse,
                Out<uint32_t> bufferLengthOut);


        // --------------------------------------------------------------------
        // Return a string constant for the given host errno value used by
        // gethostbyname and gethostbyaddr. These string constants are kept in
        // the service framework server so that it is easier for us to add,
        // remove, or update the content of these strings to reflect
        // Nintendo-specific functionality if we need to.
        // --------------------------------------------------------------------
        [MethodId(4)]
            Result GetHostStringErrorRequest(
                uint32_t errorRequestIn,
                nn.sf.OutBuffer stringErrorResponse);

        // --------------------------------------------------------------------
        // Return a string constant for the given host getaddrinfo return value
        // from getaddrinfo and getnameinfo. Like the above method, these string
        // constants are kept in the service framework server so that it is
        // easier for us to add, remove, or update the content of these strings
        // to reflect Nintendo-specific functionality if we need to.
        // --------------------------------------------------------------------
        [MethodId(5)]
            Result GetGaiStringErrorRequest(
                uint32_t errorRequestIn,
                nn.sf.OutBuffer stringErrorResponse);


        // deprecated
        [MethodId(6)]
            Result GetAddrInfoRequest(
                uint32_t cancelHandle,
                [ProcessId] nn.Bit64 pid,
                bool useNsdResolve,
                nn.sf.InBuffer serializedNodeNameIn,
                nn.sf.InBuffer serializedServiceNameIn,
                nn.sf.InBuffer serializedAddrInfoHintsIn,
                nn.sf.OutBuffer addrInfoArrayOut,
                Out<uint32_t> errnoOut,
                Out<int32_t> returnValueOut,
                Out<uint32_t> bufferLengthOut);

        // deprecated
        [MethodId(7)]
            Result GetNameInfoRequest(
                uint32_t cancelHandle,
                [ProcessId] nn.Bit64 pid,
                nn.sf.InBuffer socketAddressPointerIn,
                nn.sf.OutBuffer hostBufferOut,
                nn.sf.OutBuffer serviceBufferOut,
                uint32_t flagsIn,
                Out<uint32_t> errnoOut,
                Out<int32_t> returnValueOut);

        // --------------------------------------------------------------------
        // MethodId 8 - This method remains for games mastered prior to
        // SIGLONTD-7060 when the server contained a hash table of handles.
        // After SIGLONTD-7060 the client shim generates a random handle and
        // this random handle is passed along the service framework boundary.
        // --------------------------------------------------------------------
        [MethodId(8)]
        Result GetCancelHandleRequest(
            [ProcessId] nn.Bit64 pid,
            Out<uint32_t> RequestHandle);

        // --------------------------------------------------------------------
        // MethodId 9 - This is the service framework function signature to
        // cancel a request. It is the pre-resolver-options version
        // (SIGLONTD-11143 / SIGLO-58485) but is now handled by resolver
        // options 'set' facility after  SIGLONTD-10334/SIGLO-58527
        // --------------------------------------------------------------------
        [MethodId(9)]
        Result CancelRequest(
            [ProcessId] nn.Bit64 pid,
            uint32_t RequestHandle);

        // --------------------------------------------------------------------
        // MethodId 10 +  are the resolver options & cache enabled methods.
        // --------------------------------------------------------------------

        [MethodId(10)]
            Result GetHostByNameRequestWithOptions(
                [ProcessId] nn.Bit64 processId,
                [AutoSelectBuffer] nn.sf.InBuffer nameParam,
                [AutoSelectBuffer] nn.sf.OutBuffer serializedHostEntryOut,
                Out<uint32_t> pSerializedHostEntrySizeOut,
                uint32_t optionsRequestVersion,
                [AutoSelectBuffer] nn.sf.InBuffer serializedOptionsBuffer,
                uint32_t optionsCountIn,
                Out<int> pOutHostError,
                Out<int> pOutErrno);

        [MethodId(11)]
            Result GetHostByAddrRequestWithOptions(
                [ProcessId] nn.Bit64 processId,
                [AutoSelectBuffer] nn.sf.InBuffer inAddrParam,
                uint32_t inAddrLengthParam,
                int addressFamilyParam,
                [AutoSelectBuffer] nn.sf.OutBuffer serializedHostEntryOut,
                Out<uint32_t> pSerializedHostEntrySizeOut,
                uint32_t  optionsRequestVersion,
                [AutoSelectBuffer] nn.sf.InBuffer serializedOptionsBuffer,
                uint32_t optionsCountIn,
                Out<int> pOutHostError,
                Out<int> pOutErrno);

        [MethodId(12)]
            Result GetAddrInfoRequestWithOptions(
                [ProcessId] nn.Bit64 processId,
                nn.sf.InBuffer nodeNameParam,
                nn.sf.InBuffer serviceNameParam,
                nn.sf.InBuffer serializedHintsParam,
                [AutoSelectBuffer] nn.sf.OutBuffer serializedAddrinfoResultBuffer,
                Out<uint32_t> pSerializedAddrinfoResultBufferSize,
                Out<int> pReturnCode,
                uint32_t  optionsRequestVersion,
                [AutoSelectBuffer] nn.sf.InBuffer serializedOptionsBuffer,
                uint32_t optionsCountIn,
                Out<int> pOutHostError,
                Out<int> pOutErrno);

        [MethodId(13)]
            Result GetNameInfoRequestWithOptions(
                [ProcessId] nn.Bit64 processId,
                nn.sf.InBuffer socketAddressParamPointerIn,
                nn.sf.OutBuffer hostBufferOutParam,
                nn.sf.OutBuffer serviceBufferOutParam,
                uint32_t flagsParam,
                Out<int> pReturnCode,
                uint32_t  version,
                [AutoSelectBuffer] nn.sf.InBuffer serializedOptionsBuffer,
                uint32_t optionsCountIn,
                Out<int> pOutHostError,
                Out<int> pOutErrno);

        [MethodId(14)]
            Result ResolverSetOptionRequest(
                [ProcessId] nn.Bit64 processId,
                uint32_t  version,
                nn.sf.InBuffer serializedOption,
                Out<int> pReturnCode,
                Out<int> pOutErrno);

        [MethodId(15)]
            Result ResolverGetOptionRequest(
                [ProcessId] nn.Bit64 processId,
                uint32_t key,
                uint32_t  version,
                nn.sf.InBuffer serializedOption,
                nn.sf.OutBuffer serializedOptionBufferOut,
                Out<uint32_t> outBufferUsed,
                Out<int> pReturnCode,
                Out<int> pOutErrno);
    }
}
