﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nn/nn_Result.h>
#include <nn/socket/socket_Config.h>
#include <nn/socket/socket_Statistics.h>

namespace nn      {
namespace socket  {
    struct ResolverOption;
namespace detail  {

ssize_t     Recv(int socket, void* outBuffer, size_t outBufferLength, MsgFlag flags) NN_NOEXCEPT;
ssize_t     Recv(int socket, void* outBuffer, size_t outBufferLength, int flags) NN_NOEXCEPT;
ssize_t     RecvFrom(int socket, void* outBuffer, size_t outBufferLength, MsgFlag flags, SockAddr* pOutAddress, SockLenT* pOutAddressLength) NN_NOEXCEPT;
ssize_t     RecvFrom(int socket, void* outBuffer, size_t outBufferLength, int flags, sockaddr* pOutAddress, socklen_t* pOutAddressLength) NN_NOEXCEPT;
ssize_t     Send(int socket, const void* buffer, size_t bufferLength, MsgFlag flags) NN_NOEXCEPT;
ssize_t     Send(int socket, const void* buffer, size_t bufferLength, int flags) NN_NOEXCEPT;
ssize_t     SendTo(int socket, const void* buffer, size_t bufferLength, MsgFlag flags, const SockAddr* pAddress, SockLenT addressLength) NN_NOEXCEPT;
ssize_t     SendTo(int socket, const void* buffer, size_t bufferLength, int flags, const sockaddr* pAddress, socklen_t addressLength) NN_NOEXCEPT;
int         Accept(int socket, SockAddr* pOutAddress, SockLenT* pOutAddressLength) NN_NOEXCEPT;
int         Accept(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength) NN_NOEXCEPT;
int         Bind(int socket, const SockAddr* pAddress, SockLenT addressLength) NN_NOEXCEPT;
int         Bind(int socket, const sockaddr* pAddress, socklen_t addressLength) NN_NOEXCEPT;
int         Connect(int socket, const SockAddr* pAddress, SockLenT addressLength) NN_NOEXCEPT;
int         Connect(int socket, const sockaddr* pAddress, socklen_t addressLength) NN_NOEXCEPT;
int         GetPeerName(int socket, SockAddr* pOutAddress, SockLenT* pOutAddressLength) NN_NOEXCEPT;
int         GetPeerName(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength) NN_NOEXCEPT;
int         GetSockName(int socket, SockAddr* pOutAddress, SockLenT* pOutAddressLength) NN_NOEXCEPT;
int         GetSockName(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength) NN_NOEXCEPT;
int         GetSockOpt(int socket, Level level, Option optionName, void* pOutOptionValue, SockLenT* pOutOptionLength) NN_NOEXCEPT;
int         GetSockOpt(int socket, int level, int optionName, void* pOutOptionValue, socklen_t* pOutOptionLength) NN_NOEXCEPT;
int         Listen(int socket, int backlog) NN_NOEXCEPT;
int         SetSockOpt(int socket, Level level, Option optionName, const void* pOptionValue, SockLenT optionLength) NN_NOEXCEPT;
int         SetSockOpt(int socket, int level, int optionName, const void* pOptionValue, socklen_t   optionLength) NN_NOEXCEPT;
int         SockAtMark(int socket) NN_NOEXCEPT;
int         Shutdown(int socket, ShutdownMethod how) NN_NOEXCEPT;
int         Shutdown(int socket, int how) NN_NOEXCEPT;
int         ShutdownAllSockets(bool forced) NN_NOEXCEPT;
int         Socket(Family domain, Type type, Protocol protocol) NN_NOEXCEPT;
int         Socket(int domain, int type, int protocol) NN_NOEXCEPT;
int         SocketExempt(Family domain, Type type, Protocol protocol) NN_NOEXCEPT;
int         SocketExempt(int domain, int type, int protocol) NN_NOEXCEPT;
int         Write(int socket, const void* buffer, size_t bufferLength) NN_NOEXCEPT;
int         Read(int socket, void* outBuffer, size_t outBufferLength) NN_NOEXCEPT;
int         Close(int socket) NN_NOEXCEPT;
int         Poll(PollFd* pSocketDescriptors, NfdsT numberOfDescriptors, int timeoutMilliseconds) NN_NOEXCEPT;
int         Poll(pollfd* pSocketDescriptors, nfds_t numberOfDescriptors, int timeoutMilliseconds) NN_NOEXCEPT;
int         Fcntl(int socket, FcntlCommand command, ...) NN_NOEXCEPT;
int         Fcntl(int socket, int command, ...) NN_NOEXCEPT;
int         Select(int numberOfDescriptors, FdSet*  pReadDescriptors, FdSet*  pWriteDescriptors, FdSet*  pExceptDescriptors, TimeVal* pTimeout) NN_NOEXCEPT;
int         Select(int numberOfDescriptors, fd_set*  pReadDescriptors, fd_set*  pWriteDescriptors, fd_set*  pExceptDescriptors, timeval* pTimeout) NN_NOEXCEPT;
const char* InetNtop(Family family, const void* pNetworkAddress, char* addressStringBuffer, SockLenT addressStringBufferLength) NN_NOEXCEPT;
const char* InetNtop(int family, const void* pNetworkAddress, char* addressStringBuffer, socklen_t addressStringBufferLength) NN_NOEXCEPT;
int         InetPton(Family family, const char* pAddressString, void* pOutAddressBuffer) NN_NOEXCEPT;
int         InetPton(int family, const char* pAddressString, void* pOutAddressBuffer) NN_NOEXCEPT;
int         InetAton(const char* addressStringBuffer, InAddr* pOutNetworkAddress) NN_NOEXCEPT;
int         InetAton(const char* addressStringBuffer, in_addr* pOutNetworkAddress) NN_NOEXCEPT;
char*       InetNtoa(InAddr networkAddress) NN_NOEXCEPT;
char*       InetNtoa(in_addr networkAddress) NN_NOEXCEPT;
uint16_t    InetHtons(uint16_t hostValue) NN_NOEXCEPT;
uint32_t    InetHtonl(uint32_t hostValue) NN_NOEXCEPT;
uint16_t    InetNtohs(uint16_t networkValue) NN_NOEXCEPT;
uint32_t    InetNtohl(uint32_t networkValue) NN_NOEXCEPT;
Errno       GetLastError() NN_NOEXCEPT;
int         GetLastErrno() NN_NOEXCEPT;
void        SetLastError(Errno error) NN_NOEXCEPT;
void        SetLastErrno(int error) NN_NOEXCEPT;
ssize_t     RecvMsg(int socket, MsgHdr* pOutMessage, MsgFlag flags) NN_NOEXCEPT;
ssize_t     RecvMsg(int socket, msghdr* pOutMessage, int flags) NN_NOEXCEPT;
ssize_t     RecvMMsg(int socket, MMsgHdr* pMsgvec, size_t vlen, MsgFlag flags, nn::TimeSpan *pTimeout) NN_NOEXCEPT;
ssize_t     RecvMMsg(int socket, mmsghdr* pMsgvec, size_t vlen, int flags, nn::TimeSpan *pTimeout) NN_NOEXCEPT;
ssize_t     SendMsg(int socket, const MsgHdr* pMessage, MsgFlag flags) NN_NOEXCEPT;
ssize_t     SendMsg(int socket, const msghdr* pMessage, int flags) NN_NOEXCEPT;
ssize_t     SendMMsg(int socket, const MMsgHdr* msgvec, size_t vlen, MsgFlag flags) NN_NOEXCEPT;
ssize_t     SendMMsg(int socket, const mmsghdr* msgvec, size_t vlen, int flags) NN_NOEXCEPT;
int         Ioctl(int fd, IoctlCommand command, void* pData, size_t dataLength) NN_NOEXCEPT;
int         Ioctl(int socket, uint32_t command, void* pData, size_t dataLength) NN_NOEXCEPT;
int         Open(const char* path, OpenFlag flags) NN_NOEXCEPT;
int         Open(const char* path, int flags) NN_NOEXCEPT;
HErrno*     GetHError() NN_NOEXCEPT;
int*        GetHErrno() NN_NOEXCEPT;
HostEnt*    GetHostEntByName(const char* pName, const ResolverOption *pOptions, size_t size) NN_NOEXCEPT;
hostent*    GetHostByName(const char*, const ResolverOption*, size_t) NN_NOEXCEPT;
HostEnt*    GetHostEntByAddr(const void* pAddress, SockLenT length, Family addressFamily, const ResolverOption *pOptions, size_t size) NN_NOEXCEPT;
hostent*    GetHostByAddr(const void*, socklen_t, int, const ResolverOption*, size_t) NN_NOEXCEPT;
AiErrno     GetAddrInfo(const char* pNodeName, const char* pServername, const AddrInfo* pHints, AddrInfo** pResult, const ResolverOption *pOptions, size_t size) NN_NOEXCEPT;
int         GetAddrInfo(const char*, const char*, const addrinfo*, addrinfo**, const ResolverOption*, size_t) NN_NOEXCEPT;
AiErrno     GetNameInfo(const SockAddr* socketAddress, SockLenT socketAddressLength, char* host, size_t hostLength, char* service, size_t serviceLength, NameInfoFlag flags, const ResolverOption* pOptions, size_t size) NN_NOEXCEPT;
int         GetNameInfo(const sockaddr*, socklen_t, char*, socklen_t, char*, socklen_t, int, const ResolverOption*, size_t) NN_NOEXCEPT;
const char* HStrError(HErrno errorNumber) NN_NOEXCEPT;
const char* HStrError(int) NN_NOEXCEPT;
void        FreeAddrInfo(AddrInfo* addrInfoStorage) NN_NOEXCEPT;
void        FreeAddrInfo(addrinfo *) NN_NOEXCEPT;
const char* GAIStrError(AiErrno errorCode) NN_NOEXCEPT;
const char* GAIStrError(int) NN_NOEXCEPT;
int         ResolverGetOption(ResolverOption* pOptionOut, uint32_t key) NN_NOEXCEPT;
int         ResolverSetOption(const ResolverOption& option) NN_NOEXCEPT;
int         Sysctl(int* pMibEntries, size_t mibEntryCount, void* pOldValue, size_t* pOldValueLength, void* pNewValue, size_t newValueLength) NN_NOEXCEPT;
int         DuplicateSocket(int socket, uint64_t ownerProcessId) NN_NOEXCEPT;
int         GetResourceStatistics(StatisticsType type, void* outBuffer, size_t outBufferLength, uint32_t options) NN_NOEXCEPT;
Result      Initialize(void* memoryPool, size_t memoryPoolSize, size_t allocatorPoolSize, int concurrentLimit) NN_NOEXCEPT;
Result      Initialize(const nn::socket::Config& config) NN_NOEXCEPT;
Result      Finalize() NN_NOEXCEPT;

}}} /* nn::socket::detail */
