﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sfsmpl_CreateCalculator.h"

#include "sfsmpl_CalculatorImpl.h"
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace sfsmpl {

namespace {

// 実装クラス CalculatorImpl を、ICalculator サービスオブジェクトとして参照できるようにする。
// なお、グローバルな領域に置くため、寿命管理は必要ないため nn::sf::UnmanagedServiceObject を使用する。
nn::sf::UnmanagedServiceObject<ICalculator, CalculatorImpl> g_Calculator;

}

nn::sf::SharedPointer<ICalculator> GetCalculatorByDfc() NN_NOEXCEPT
{
    return g_Calculator.GetShared();
}

}}
