﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <utility>

#include "sf_HipcEmulatedSession.h"
#include "detail/sf_HipcWindowsNamedPipe.h"


namespace nn { namespace sf { namespace hipc {

class HipcEmulatedServerSessionRequest;

class HipcEmulatedNamedPipeClientSession
    : public HipcEmulatedClientSession
{
private:
    SharedPointer<detail::HipcWindowsNamedPipe> m_pNamedPipe;

protected:
    explicit HipcEmulatedNamedPipeClientSession(detail::HipcWindowsNamedPipe* pNamedPipe) NN_NOEXCEPT;
    ~HipcEmulatedNamedPipeClientSession() NN_NOEXCEPT;

public:
    static HipcEmulatedNamedPipeClientSession* Create(detail::HipcWindowsNamedPipe* pNamedPipe) NN_NOEXCEPT;

    virtual HipcEmulatedSessionRequest* CreateRequest(void* clientMessageBuffer, size_t clientMessageBufferSize) NN_NOEXCEPT NN_OVERRIDE;

    const detail::HipcWindowsNamedPipe* GetNamedPipe() NN_NOEXCEPT { return m_pNamedPipe.Get(); }
    detail::HipcWindowsNamedPipe* DetachNamedPipe() NN_NOEXCEPT { return m_pNamedPipe.Detach(); }
};


class HipcEmulatedNamedPipeServerSession
    : public HipcEmulatedServerSession
{
public:
    class IHipcEmulatedNamedPipeServerSessionNotificationReceiver
    {
    protected:
        ~IHipcEmulatedNamedPipeServerSessionNotificationReceiver() {}
    public:
        virtual void OnSessionClosing(HipcEmulatedNamedPipeServerSession* pSession, detail::HipcWindowsNamedPipe* pNamedPipe) = 0;
    };

private:
    SharedPointer<detail::HipcWindowsNamedPipe> m_pNamedPipe;

    IHipcEmulatedNamedPipeServerSessionNotificationReceiver* m_pNotificationReceiver;

    HipcEmulatedServerSessionRequest* m_pSessionRequest;

protected:
    explicit HipcEmulatedNamedPipeServerSession(SharedPointer<detail::HipcWindowsNamedPipe> pNamedPipe) NN_NOEXCEPT;
    ~HipcEmulatedNamedPipeServerSession() NN_NOEXCEPT;

public:
    static HipcEmulatedNamedPipeServerSession* Create(SharedPointer<detail::HipcWindowsNamedPipe> pNamedPipe) NN_NOEXCEPT;

    void SetNotificationReceiver(IHipcEmulatedNamedPipeServerSessionNotificationReceiver* pNotificationReceiver) NN_NOEXCEPT;

    virtual void AttachReceiveEvent(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result ReceiveRequest(bool* pClosed, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Reply(void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT NN_OVERRIDE;
};


std::pair<
    HipcEmulatedNamedPipeServerSession*,
    HipcEmulatedNamedPipeClientSession*
> CreateHipcEmulatedNamedPipeSessionPair(nn::sf::ISharedObject* parentPort = nullptr) NN_NOEXCEPT;

}}}
