﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>
#include <nn/nn_Common.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <nn/nn_Windows.h>

#include "sf_HipcEmulatedPort.h"
#include "sf_HipcEmulatedNamedPipeSession.h"
#include "detail/sf_HipcWindowsNamedPipe.h"


namespace nn { namespace sf { namespace hipc {

class HipcEmulatedServerPortAcceptablePipeNotificationWorker;

class HipcEmulatedNamedPipeClientPort
    : public HipcEmulatedClientPort
{
private:
    os::Mutex m_StateLock;
    TCHAR m_PipeName[detail::HipcWindowsNamedPipe::PipeNameLengthMax];
    detail::HipcWindowsNamedPipe* m_pCurrentNamedPipe;

protected:
    explicit HipcEmulatedNamedPipeClientPort(const TCHAR* pipeName) NN_NOEXCEPT;
    ~HipcEmulatedNamedPipeClientPort() NN_NOEXCEPT;

public:
    static HipcEmulatedNamedPipeClientPort* Create(const TCHAR* pipeName) NN_NOEXCEPT;

    virtual void AttachConnectEvent(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE;
    virtual HipcEmulatedClientSession* Connect(bool blocking) NN_NOEXCEPT NN_OVERRIDE;
};


class HipcEmulatedNamedPipeServerPort
    : public HipcEmulatedServerPort
    , public HipcEmulatedNamedPipeServerSession::IHipcEmulatedNamedPipeServerSessionNotificationReceiver
{
private:
    os::Mutex m_StateLock;

    int m_MaxSessions;
    SharedPointer<detail::HipcWindowsNamedPipe>* m_NamedPipes;

    HipcEmulatedNamedPipeServerSession** m_pChildSessions;
    HipcEmulatedServerPortAcceptablePipeNotificationWorker* m_pNotificationWorker;

protected:
    HipcEmulatedNamedPipeServerPort(const TCHAR* pPipeName, int maxSessions) NN_NOEXCEPT;
    ~HipcEmulatedNamedPipeServerPort() NN_NOEXCEPT;

public:
    static HipcEmulatedNamedPipeServerPort* Create(const TCHAR* pPipeName, int maxSessions) NN_NOEXCEPT;

    void StartAccepting() NN_NOEXCEPT;
    void StopAccepting() NN_NOEXCEPT;

    virtual void AttachAcceptEvent(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE;
    virtual void WaitAccept() NN_NOEXCEPT NN_OVERRIDE;
    virtual HipcEmulatedServerSession* Accept() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnSessionClosing(HipcEmulatedNamedPipeServerSession* pSession, detail::HipcWindowsNamedPipe* pNamedPipe) NN_NOEXCEPT NN_OVERRIDE;

private:
    void RegisterChildSession(HipcEmulatedNamedPipeServerSession* pSession) NN_NOEXCEPT;
    void UnregisterChildSession(HipcEmulatedNamedPipeServerSession* pSession) NN_NOEXCEPT;
    void UnregisterAllChildSession() NN_NOEXCEPT;
};


std::pair<
    HipcEmulatedNamedPipeServerPort*,
    HipcEmulatedNamedPipeClientPort*
> CreateHipcEmulatedNamedPipePortPair(int maxSessions) NN_NOEXCEPT;

}}}
