﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <utility>

#include "sf_HipcEmulatedSession.h"


namespace nn { namespace sf { namespace hipc {

class HipcEmulatedInProcessSession;

class HipcEmulatedInProcessClientSession
    : public HipcEmulatedClientSession
{
private:
    SharedPointer<HipcEmulatedInProcessSession> m_Session;

protected:
    explicit HipcEmulatedInProcessClientSession(HipcEmulatedInProcessSession* session) NN_NOEXCEPT;
    ~HipcEmulatedInProcessClientSession() NN_NOEXCEPT;

public:
    virtual HipcEmulatedSessionRequest* CreateRequest(void* clientMessageBuffer, size_t clientMessageBufferSize) NN_NOEXCEPT NN_OVERRIDE;
};


class HipcEmulatedInProcessServerSession
    : public HipcEmulatedServerSession
{
private:
    SharedPointer<HipcEmulatedInProcessSession> m_Session;

protected:
    explicit HipcEmulatedInProcessServerSession(HipcEmulatedInProcessSession* session) NN_NOEXCEPT;
    ~HipcEmulatedInProcessServerSession() NN_NOEXCEPT;

public:
    virtual void AttachReceiveEvent(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result ReceiveRequest(bool* pClosed, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Reply(void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT NN_OVERRIDE;
};


std::pair<
    HipcEmulatedInProcessServerSession*,
    HipcEmulatedInProcessClientSession*
> CreateHipcEmulatedInProcessSessionPair(nn::sf::ISharedObject* parentPort = nullptr) NN_NOEXCEPT;

}}}
