﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/sf/hipc/sf_HipcDirectApi.h>
#include <nn/sf/hipc/sf_HipcServiceResolutionApi.h>
#include <nn/sf/hipc/server/sf_HipcServerApiModel.h>


namespace nn { namespace sf { namespace hipc { namespace server {

Result HipcServerApiModel::CreatePort(HipcServerPortHandle* pOutServer, HipcClientPortHandle* pOutClient, int maxSessions) NN_NOEXCEPT
{
    if (m_EnabledIpcOnWindows)
    {
        return hipc::CreatePort(pOutServer, pOutClient, maxSessions);
    }
    else
    {
        return hipc::CreateInProcessPort(pOutServer, pOutClient, maxSessions);
    }
}

Result HipcServerApiModel::CreateSession(HipcServerSessionHandle* pOutServer, HipcClientSessionHandle* pOutClient) NN_NOEXCEPT
{
    if (m_EnabledIpcOnWindows)
    {
        return hipc::CreateSession(pOutServer, pOutClient);
    }
    else
    {
        return hipc::CreateInProcessSession(pOutServer, pOutClient);
    }
}

Result HipcServerApiModel::RegisterHipcService(HipcServerPortHandle* pOut, int32_t maxSessions, const char* name) NN_NOEXCEPT
{
    if (m_EnabledIpcOnWindows)
    {
        return hipc::RegisterHipcService(pOut, maxSessions, name);
    }
    else
    {
        return hipc::RegisterInProcessHipcService(pOut, maxSessions, name);
    }
}

void HipcServerApiModel::UnregisterHipcService(const char* name) NN_NOEXCEPT
{
    if (m_EnabledIpcOnWindows)
    {
        hipc::UnregisterHipcService(name);
    }
    else
    {
        hipc::UnregisterInProcessHipcService(name);
    }
}

HipcServerApiModel* GetDefaultServerApiModel() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(HipcServerApiModel, defaultServerApiModel, (false));
    return &defaultServerApiModel;
}

HipcServerApiModel* GetWindowsIpcEnabledServerApiModel() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(HipcServerApiModel, windowsIpcEnabledServerApiModel, (true));
    return &windowsIpcEnabledServerApiModel;
}

}}}}
