﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sdmmc_PortMmc0.h"
#include <nn/TargetConfigs/build_Base.h>
#if (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1))
    #include "sdmmc_SdmmcController.tegra-k1.h"
#endif
#if (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX))
    #include "sdmmc_SdmmcController.tegra-x1.h"
#endif

namespace nn { namespace sdmmc {
namespace detail {

namespace
{
    Sdmmc4Controller g_Mmc0HostController;
    MmcDeviceAccessor g_Mmc0DeviceAccessor(&g_Mmc0HostController);
}

IHostController* GetHostControllerOfPortMmc0() NN_NOEXCEPT
{
    return &g_Mmc0HostController;
}

IDeviceAccessor* GetDeviceAccessorOfPortMmc0() NN_NOEXCEPT
{
    return &g_Mmc0DeviceAccessor;
}

MmcDeviceAccessor* GetMmcDeviceAccessorOfPortMmc0() NN_NOEXCEPT
{
    return &g_Mmc0DeviceAccessor;
}

} // namespace detail {
}} // namespace nn { namespace sdmmc {
