﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/svc/svc_Base.h>
#include <nn/ro/detail/ro_RoModule.h>
#include <cstring>

namespace nn { namespace rtld {
    void Initialize0(uintptr_t base, const nn::ro::detail::Elf::Dyn* pDynamicSection);
    void Initialize1(uintptr_t base, const nn::ro::detail::Elf::Dyn* pDynamicSection);
    void CallInit();
    uintptr_t LookupGlobalAuto(const char* pName);
    uintptr_t Bind(nn::ro::detail::RoModule* pModule, uint32_t index);

    void BindEntry();
}}

namespace nn { namespace ro { namespace detail {
    extern bool g_EnableDebugLog;
    extern LookupGlobalManualFunctionPointer g_LookupGlobalManualFunctionPointer;
}}}

#define NN_RTLD_ABORT_UNLESS(x) (static_cast<void>((x) || (nn::svc::Break(nn::svc::BreakReason_Panic, 0, 0), 0)))
#define NN_RTLD_PUTS(x) nn::svc::OutputDebugString(x, std::strlen(x))
