﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include "rtld.AssemblyOffset.h"

    .section ".rtld.init", "ax"
    .align   2
    .global  _start
    .type    _start, %function
_start:
    b       .Lrtld_start
    .word   __rocrt - _start

.Lrtld_start:
    cmp     x0, #0
    b.ne    .Lhandle_exception

    mov     w19, w1

    // bss クリア
    bl      2f
1:  .word   __bss_start - 1b
2:  ldr     w0, [x30]
    sxtw    x0, w0
    add     x0, x0, x30

    bl      2f
1:  .word   __bss_end - 1b
2:  ldr     w2, [x30]
    sxtw    x2, w2
    add     x2, x2, x30
    sub     x2, x2, x0

    mov     w1, #0
    bl      memset

    // get load base address
    //  x19 <- thread handle
    bl      2f
1:  .word   _start - 1b
2:  ldr     w0, [x30]
    sxtw    x0, w0
    add     x0, x0, x30  // r0 <- load base address


    // get .dynamic address
    //  r0 <- load base address
    //  x19 <- thread handle
    bl      2f
1:  .word   _DYNAMIC - 1b
2:  ldr     w1, [x30]
    sxtw    x1, w1
    add     x1, x1, x30  //  r1 <- .dynamic address


    // r0 <- load base address
    // r1 <- .dynamic address
    // x19 <- thread handle
    mov     x20, x0
    mov     x21, x1
    bl      _ZN2nn4rtld11Initialize0EmPKNS_2ro6detail3Elf5Elf643DynE
    mov     x0, x20
    mov     x1, x21
    bl      _ZN2nn4rtld11Initialize1EmPKNS_2ro6detail3Elf5Elf643DynE

    mov     w0, w19

    adrp    x1, :got:__arg_start
    ldr     x1, [x1, #:got_lo12:__arg_start]

    bl      2f
1:  .word   _ZN2nn4rtld22EnableExceptionHandlerEv - 1b
2:  ldr     w2, [x30]
    sxtw    x2, w2
    add     x2, x2, x30

    bl      2f
1:  .word   _ZN2nn4rtld8CallInitEv - 1b
2:  ldr     w3, [x30]
    sxtw    x3, w3
    add     x3, x3, x30

    bl      _ZN2nn4init5StartEmmPFvvES2_
1:  b       1b





.Lhandle_exception:
    // 未初期化の場合は多重例外を防ぐ
    bl      2f
1:  .word   __rt_initialized - 1b
2:  ldr     w2, [x30]
    sxtw    x2, w2
    add     x2, x2, x30
    ldr     w2, [x2]
    cbz     w2, .Lnot_handled

    // nn::os::detail::UserExceptionHandler() 呼び出し
    adrp    x2, :got:_ZN2nn2os6detail20UserExceptionHandlerEv
    ldr     x2, [x2, #:got_lo12:_ZN2nn2os6detail20UserExceptionHandlerEv]
    cbz     x2, .Lnot_handled
    br      x2

.Lnot_handled:
    ldr     x0, =RESULT_NOT_HANDLED
    bl      _ZN2nn3svc7aarch644lp6419ReturnFromExceptionENS_6ResultE
0:  b       0b

    .size   _start, [. - _start]

    .section .text, "ax"
    .align   2
    .global  _ZN2nn4rtld9BindEntryEv
    .type    _ZN2nn4rtld9BindEntryEv, @function
_ZN2nn4rtld9BindEntryEv:
    ldr     x17, [sp]
    str     x29, [sp]
    stp     x8,  x19, [sp, #-16]!
    stp     x6,  x7,  [sp, #-16]!
    stp     x4,  x5,  [sp, #-16]!
    stp     x2,  x3,  [sp, #-16]!
    stp     x0,  x1,  [sp, #-16]!
    stp     q6,  q7,  [sp, #-0x20]!
    stp     q4,  q5,  [sp, #-0x20]!
    stp     q2,  q3,  [sp, #-0x20]!
    stp     q0,  q1,  [sp, #-0x20]!
    mov     x29, sp

    mov     x19, x17

#if defined NN_BUILD_CONFIG_ABI_LP64
    sub     x1, x17, x16
    sub     x1, x1, #8
    lsr     x1, x1, #3
    ldr     x0, [x16, #-8]
    bl      _ZN2nn4rtld4BindEPNS_2ro6detail8RoModuleEj
    str     x0, [x19]
    mov     x16, x0
#else
    sub     w1, w17, w16
    sub     w1, w1, #4
    lsr     w1, w1, #2
    ldr     w0, [x16, #-4]
    bl      _ZN2nn4rtld4BindEPNS_2ro6detail8RoModuleEj
    str     w0, [x19]
    mov     w16, w0
#endif

    ldp     q0,  q1,  [sp], #0x20
    ldp     q2,  q3,  [sp], #0x20
    ldp     q4,  q5,  [sp], #0x20
    ldp     q6,  q7,  [sp], #0x20
    ldp     x0,  x1,  [sp], #16
    ldp     x2,  x3,  [sp], #16
    ldp     x4,  x5,  [sp], #16
    ldp     x6,  x7,  [sp], #16
    ldp     x8,  x19, [sp], #16
    ldp     x29, x30, [sp], #16
    br      x16
    .size   _ZN2nn4rtld9BindEntryEv, [. - _ZN2nn4rtld9BindEntryEv]

    .section .text, "ax"
    .align   2
    .global  _ZN2nn4rtld22EnableExceptionHandlerEv
    .type    _ZN2nn4rtld22EnableExceptionHandlerEv, @function
_ZN2nn4rtld22EnableExceptionHandlerEv:
    mov     x0, x30

    bl      2f
1:  .word   __rt_initialized - 1b
2:  ldr     w2, [x30]
    sxtw    x2, w2
    add     x2, x2, x30
    mov     w1, #1
    str     w1, [x2]

    mov     x30, x0
    ret
    .size   _ZN2nn4rtld22EnableExceptionHandlerEv, [. - _ZN2nn4rtld22EnableExceptionHandlerEv]

    .data
    .balign 8
__rt_initialized:
    .word   0
    .size   __rt_initialized, [. - __rt_initialized]
