﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ro/detail/ro_PortName.h>
#include <nn/ro/ro_DebugMonitorApi.h>
#include <nn/ro/detail/ro_DebugMonitorInterface.h>
#include <nn/svc/svc_Handle.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

namespace nn { namespace ro {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<10 * 1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::ro::detail::IDebugMonitorInterface> g_RefDebugMonitorInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForDebugMonitor() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<nn::ro::detail::IDebugMonitorInterface, MyAllocator::Policy>(
            &g_RefDebugMonitorInterface, nn::ro::detail::PortNameForDebugMonitor);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForDebugMonitor() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( g_IsInitialized );
        nn::sf::ReleaseSharedObject(g_RefDebugMonitorInterface.Detach());

        g_IsInitialized = false;
        return ResultSuccess();
    }

    Result GetProcessModuleInfo(int* pOutCount, ro::ModuleInfo* pBuffer, int num, nn::os::ProcessId id) NN_NOEXCEPT
    {
        auto outBuffer = nn::sf::OutArray<ModuleInfo>(pBuffer, num);
        return g_RefDebugMonitorInterface->GetProcessModuleInfo(
            reinterpret_cast<int32_t*>(pOutCount), outBuffer, id);
    }

}}
