﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>

    .section .text, "ax"
    .align   2
    .global  _ZN2nn2ro9BindEntryEv
    .type    _ZN2nn2ro9BindEntryEv, @function
_ZN2nn2ro9BindEntryEv:
    ldr     x17, [sp]
    str     x29, [sp]
    stp     x8,  x19, [sp, #-16]!
    stp     x6,  x7,  [sp, #-16]!
    stp     x4,  x5,  [sp, #-16]!
    stp     x2,  x3,  [sp, #-16]!
    stp     x0,  x1,  [sp, #-16]!
    stp     q6,  q7,  [sp, #-0x20]!
    stp     q4,  q5,  [sp, #-0x20]!
    stp     q2,  q3,  [sp, #-0x20]!
    stp     q0,  q1,  [sp, #-0x20]!
    mov     x29, sp

    mov     x19, x17

#if defined NN_BUILD_CONFIG_ABI_LP64
    sub     x1, x17, x16
    sub     x1, x1, #8
    lsr     x1, x1, #3
    ldr     x0, [x16, #-8]
    bl      _ZN2nn2ro6detail4BindEPNS1_8RoModuleEj
    str     x0, [x19]
    mov     x16, x0
#else
    sub     w1, w17, w16
    sub     w1, w1, #4
    lsr     w1, w1, #2
    ldr     w0, [x16, #-4]
    bl      _ZN2nn2ro6detail4BindEPNS1_8RoModuleEj
    str     w0, [x19]
    mov     w16, w0
#endif

    ldp     q0,  q1,  [sp], #0x20
    ldp     q2,  q3,  [sp], #0x20
    ldp     q4,  q5,  [sp], #0x20
    ldp     q6,  q7,  [sp], #0x20
    ldp     x0,  x1,  [sp], #16
    ldp     x2,  x3,  [sp], #16
    ldp     x4,  x5,  [sp], #16
    ldp     x6,  x7,  [sp], #16
    ldp     x8,  x19, [sp], #16
    ldp     x29, x30, [sp], #16
    br      x16
    .size   _ZN2nn2ro9BindEntryEv, [. - _ZN2nn2ro9BindEntryEv]

