﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nnc/nn_Result.h>

#include <type_traits>

static_assert(std::is_same<nnResultInnerType, nn::Result::InnerType>::value, "");

static_assert(nnResultInnerSuccessValue == nn::ResultSuccess::InnerSuccessValue, "");
static_assert(nnResultModuleBitsOffset == nn::result::detail::ResultTraits::ModuleBitsOffset, "");
static_assert(nnResultModuleBitsCount == nn::result::detail::ResultTraits::ModuleBitsCount, "");
static_assert(nnResultDescriptionBitsOffset == nn::result::detail::ResultTraits::DescriptionBitsOffset, "");
static_assert(nnResultDescriptionBitsCount == nn::result::detail::ResultTraits::DescriptionBitsCount, "");
static_assert(nnResultReservedBitsOffset == nn::result::detail::ResultTraits::ReservedBitsOffset, "");
static_assert(nnResultReservedBitsCount == nn::result::detail::ResultTraits::ReservedBitsCount, "");

int nnResultGetModule(nnResult result)
{
    return (result._value >> nnResultModuleBitsOffset) & ~(~((nnResultInnerType)0) << nnResultModuleBitsCount);
}

int nnResultGetDescription(nnResult result)
{
    return (result._value >> nnResultDescriptionBitsOffset) & ~(~((nnResultInnerType)0) << nnResultDescriptionBitsCount);
}

bool nnResultIsSuccess(nnResult result)
{
    return result._value == nnResultInnerSuccessValue;
}

bool nnResultIsFailure(nnResult result)
{
    return !nnResultIsSuccess(result);
}

nnResult nnResultSuccess()
{
    nnResult ret = { nnResultInnerSuccessValue };
    return ret;
}
