﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pm/pm_ShellApi.h>
#include <nn/pm/detail/pm_ShellInterface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace pm {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::pm::detail::IShellInterface> g_RefShellInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForShell() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<
            nn::pm::detail::IShellInterface, MyAllocator::Policy>(
                &g_RefShellInterface, nn::pm::detail::PortNameForShell);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForShell() NN_NOEXCEPT
    {
        NN_ABORT("not implemented");
        return ResultSuccess();
    }

    Result LaunchProgram(os::ProcessId* pOut, const  ncm::ProgramLocation& location, int32_t flags) NN_NOEXCEPT
    {
        return g_RefShellInterface->LaunchProgram(pOut, location, flags);
    }

    Result TerminateProcess(os::ProcessId processId) NN_NOEXCEPT
    {
        return g_RefShellInterface->TerminateProcess(processId);
    }

    Result TerminateProgram(ncm::ProgramId programId) NN_NOEXCEPT
    {
        return g_RefShellInterface->TerminateProgram(programId);
    }

    Result GetProcessEventEvent(os::SystemEvent* pOut) NN_NOEXCEPT
    {
        sf::NativeHandle temp;
        auto ret = g_RefShellInterface->GetProcessEventHandle(&temp);
        pOut->Attach(temp.GetOsHandle(), true, os::InvalidNativeHandle, false, os::EventClearMode_ManualClear);
        temp.Detach();
        return ret;
    }

    Result GetProcessEventInfo(ProcessEventInfo* pOut) NN_NOEXCEPT
    {
        return g_RefShellInterface->GetProcessEventInfo(pOut);
    }

    Result GetApplicationProcessIdForShell(os::ProcessId* pOut) NN_NOEXCEPT
    {
        return g_RefShellInterface->GetApplicationProcessIdForShell(pOut);
    }

    Result NotifyBootFinished() NN_NOEXCEPT
    {
        return g_RefShellInterface->NotifyBootFinished();
    }

    Result BoostSystemMemoryResourceLimit(int64_t boostSize) NN_NOEXCEPT
    {
        return g_RefShellInterface->BoostSystemMemoryResourceLimit(boostSize);
    }

}}
