﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/os/os_Mutex.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ProxyObjectAllocator.h>
#include <nn/util/util_Optional.h>

#include <nn/pm/pm_BootModeApi.h>
#include <nn/pm/detail/pm_BootModeInterface.h>

namespace nn { namespace pm {

    namespace
    {
        sf::ProxyObjectAllocator<1> g_ServiceObjectAllocator = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER;

        sf::SharedPointer<detail::IBootModeInterface> GetInterface() NN_NOEXCEPT
        {
            sf::SharedPointer<detail::IBootModeInterface> p;
            NN_ABORT_UNLESS_RESULT_SUCCESS(sf::CreateHipcProxyByName<detail::IBootModeInterface>(
                &p, g_ServiceObjectAllocator.GetMemoryResource(), detail::PortNameForBootMode));

            return p;
        }
    }

    BootMode GetBootMode() NN_NOEXCEPT
    {
        static os::Mutex s_Mutex(false);
        std::lock_guard<os::Mutex> guard(s_Mutex);

        static util::optional<BootMode> s_BootMode;
        if(!s_BootMode)
        {
            g_ServiceObjectAllocator.Initialize();
            NN_UTIL_SCOPE_EXIT{ g_ServiceObjectAllocator.Finalize(); };

            Bit32 bootMode;
            NN_ABORT_UNLESS_RESULT_SUCCESS(GetInterface()->GetBootMode(&bootMode));

            s_BootMode = static_cast<BootMode>(bootMode);
        }

        return *s_BootMode;
    }

    void SetMaintenanceBoot() NN_NOEXCEPT
    {
        g_ServiceObjectAllocator.Initialize();
        NN_UTIL_SCOPE_EXIT{ g_ServiceObjectAllocator.Finalize(); };

        NN_ABORT_UNLESS_RESULT_SUCCESS(GetInterface()->SetMaintenanceBoot());
    }
}}
