﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   PINMUX ドライバの API インタフェース部分。
 */

#include <nn/nn_Common.h>

#include <nn/pinmux/driver/pinmux_Lib.h>
#include <nn/pinmux/driver/pinmux_Api.h>
#include <nn/pinmux/driver/pinmux_ApiForHardwareTest.h>
#include <nn/pinmux/pinmux_Type.h>

namespace nn {
namespace pinmux {
namespace driver {

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

void OpenSession(PinmuxSession* pOutSession, AssignablePinGroupName name) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(name);
}

void CloseSession(PinmuxSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void SetPinAssignment(PinmuxSession* pSession, PinAssignment assignment) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(assignment);
}

PinAssignment GetPinAssignment(PinmuxSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return static_cast<PinAssignment>(0);
}

void OpenSessionForHardwareTest(PinmuxSession* pOutSession, AssignablePinGroupNameForHardwareTest name) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(name);
}

void CloseSessionForHardwareTest(PinmuxSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void SetPinAssignmentForHardwareTest(PinmuxSession* pSession, PinAssignmentForHardwareTest assignment) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(assignment);
}

void Suspend() NN_NOEXCEPT
{
}

void Resume() NN_NOEXCEPT
{
}

void SetInitialConfig() NN_NOEXCEPT
{
}

void SetInitialDrivePadConfig() NN_NOEXCEPT
{
}

} // driver
} // pinmux
} // nn
