﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   デバイスドライバ向けユーティリティ関数とクラス
 */

#pragma once

#include <nn/os.h>

namespace nn{
namespace pinmux{
namespace driver{
namespace detail{

// address に指定したレジスタの読み出しを実行します。
// TegraX1 では レジスタの書き込み完了に使用します。
inline void DummyRead(volatile Bit32* address)
{
    (void)(*address);
}

inline void WriteMasked32( volatile Bit32* address, Bit32 value, Bit32 mask)
{
    *address = (*address & ~mask) | (value & mask);
}

template <typename UInt>
inline void SetBit(volatile UInt* address, int value, int pos)
{
    auto tmp = *address;
    if (value)
    {
        tmp |= (static_cast<UInt>(1) << pos);
    }
    else
    {
        tmp &= ~(static_cast<UInt>(1) << pos);
    }
    *address = tmp;
}

template <typename UInt>
inline bool GetBit(volatile UInt* address, int pos)
{
    return (*address >> pos) & 1;
}

} // detail
} // driver
} // pinmux
} // nn
