﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ovln/ovln_ReceiverForOverlay.h>

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>

#include <atomic>
#include <nn/ovln/ovln_Receiver.h>
#include <new>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>

#include "ovln_OverlayCommonInternal.h"

namespace nn { namespace ovln {

Result InitializeReceiverLibraryForOverlay() NN_NOEXCEPT
{
    return InitializeReceiverLibrary();
}

void FinalizeReceicerLibraryForOverlay() NN_NOEXCEPT
{
    FinalizeReceicerLibrary();
}

namespace {

struct ReceiverForOverlay
{
    Receiver receiver;
};
NN_STATIC_ASSERT(sizeof(ReceiverForOverlay) <= sizeof(ReceiverForOverlayType));

}

Result InitializeReceiver(ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    auto p = new (pReceiver) ReceiverForOverlay;
    NN_UTIL_SCOPE_EXIT
    {
        if (p)
        {
            p->~ReceiverForOverlay();
        }
    };

    NN_RESULT_DO(p->receiver.Initialize());
    NN_RESULT_DO(p->receiver.AddSource(ovln::detail::GetOverlaySourceName()));

    p = nullptr;
    NN_RESULT_SUCCESS;
}

void FinalizeReceiver(ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    p->~ReceiverForOverlay();
}

bool TryReceive(Message* pOut, ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    return p->receiver.TryReceive(pOut);
}

bool TryReceive(Message* pOut, os::Tick* pOutTick, ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    NN_SDK_REQUIRES_NOT_NULL(pOutTick);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    return p->receiver.TryReceive(pOut, pOutTick);
}

void Receive(Message* pOut, ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    p->receiver.Receive(pOut);
}

void Receive(Message* pOut, os::Tick* pOutTick, ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    NN_SDK_REQUIRES_NOT_NULL(pOutTick);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    p->receiver.Receive(pOut, pOutTick);
}

bool HasMessageToReceive(ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    return p->receiver.HasMessageToReceive();
}

void WaitForMessageToReceive(ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    p->receiver.WaitForMessageToReceive();
}

void InitializeMultiWaitHolder(os::MultiWaitHolderType* pMultiWaitHolder, ReceiverForOverlayType* pReceiver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pMultiWaitHolder);
    NN_SDK_REQUIRES_NOT_NULL(pReceiver);
    auto p = reinterpret_cast<ReceiverForOverlay*>(pReceiver);
    p->receiver.AttachWaitHolder(pMultiWaitHolder);
}

}}
