﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_BitTypes.h>
#include <nn/os/os_Config.h>

#include <nn/svc/svc_Types.common.h>
#include <nn/svc/svc_ThreadLocalRegion.h>

#include "osdbg_Types.h"
#include "osdbg_ThreadInfo-os.horizon.h"

namespace nn { namespace osdbg {
namespace detail {

//--------------------------------------------------------------------------
//  ILP32 環境下と同じ内部イメージを持つ svc::ThreadLocalRegion 相当の構造体。
//  サイズやアライメントが、この構造体利用者のビルド環境によらず一定となる。
//
struct  ThreadLocalRegionIlp32
{
    Bit32           messageBuffer[64];
    uintptr32_t     reserved[48];
    struct
    {
        uintptr64_t threadId;
        uintptr32_t tls[nn::svc::TLS_NUM - 8];
        uintptr32_t _locale_ptr;
        int32_t     _errno_val;
        uintptr32_t thread_data;
        uintptr32_t eh_globals;
        uintptr32_t thread_pointer;
        uintptr32_t pThreadType;
    };
};

#if defined(NN_BUILD_CONFIG_ABI_ILP32)
NN_OSDBG_STATIC_ASSERT_SIZEOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32);
NN_OSDBG_STATIC_ASSERT_ALIGNOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32);

NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, messageBuffer);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, reserved);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, threadId);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, tls);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, _locale_ptr);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, _errno_val);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, thread_data);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, eh_globals);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, thread_pointer);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionIlp32, pThreadType);
#endif

//--------------------------------------------------------------------------
//  LP64 環境下と同じ内部イメージを持つ svc::ThreadLocalRegion 相当の構造体。
//  サイズやアライメントが、この構造体利用者のビルド環境によらず一定となる。
//
struct  ThreadLocalRegionLp64
{
    Bit32           messageBuffer[64];
    uintptr64_t     reserved[16];
    struct
    {
        uintptr64_t threadId;
        uintptr64_t tls[nn::svc::TLS_NUM - 7];
        uintptr64_t _locale_ptr;
        int64_t     _errno_val;
        uintptr64_t thread_data;
        uintptr64_t eh_globals;
        uintptr64_t thread_pointer;
        uintptr64_t pThreadType;
    };
};

#if defined(NN_BUILD_CONFIG_ABI_LP64)
NN_OSDBG_STATIC_ASSERT_SIZEOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64);
NN_OSDBG_STATIC_ASSERT_ALIGNOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64);

NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, messageBuffer);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, reserved);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, threadId);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, tls);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, _locale_ptr);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, _errno_val);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, thread_data);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, eh_globals);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, thread_pointer);
NN_OSDBG_STATIC_ASSERT_OFFSETOF(svc::ThreadLocalRegion, ThreadLocalRegionLp64, pThreadType);
#endif

//--------------------------------------------------------------------------
//  ILP32/LP64 ABI 共用の svc::ThreadLocalRegion 相当の構造体。
//
union   ThreadLocalRegionCommon
{
    ThreadLocalRegionIlp32  ilp32;
    ThreadLocalRegionLp64   lp64;
};


//--------------------------------------------------------------------------
//  関数プロトタイプ

inline ThreadLocalRegionCommon* GetTargetThreadLocalRegion(ThreadInfo* info) NN_NOEXCEPT
{
    return reinterpret_cast<ThreadLocalRegionCommon*>( info->_debugInfoCreateThread.localRegionBaseAddress );
}

ThreadTypeCommon* GetTargetThreadType(ThreadInfo* info) NN_NOEXCEPT;


//--------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::osdbg

