﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/os/os_TickApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"
#include "detail/os_TickManager.h"


//--------------------------------------------------------------------------
//  C++ 関数の定義
//--------------------------------------------------------------------------

namespace nn { namespace os {

//--------------------------------------------------------------------------
//  システムチック値の取得
Tick GetSystemTick() NN_NOEXCEPT
{
    return  detail::GetTickManagerInstance()->GetTick();
}


//--------------------------------------------------------------------------
//  システムチック値の周波数を取得
int64_t GetSystemTickFrequency() NN_NOEXCEPT
{
    return  detail::GetTickManagerInstance()->GetTickFrequency();
}


//--------------------------------------------------------------------------
//  システムチックをシステム時間に変換
TimeSpan ConvertToTimeSpan(Tick tickValue) NN_NOEXCEPT
{
    return  detail::GetTickManagerInstance()->ConvertToTimeSpan( tickValue );
}

//--------------------------------------------------------------------------
//  システム時間をシステムチックに変換
Tick ConvertToTick(TimeSpan timeSpan) NN_NOEXCEPT
{
    return  detail::GetTickManagerInstance()->ConvertToTick( timeSpan );
}


}} // namespace nn::os

