﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_ThreadApi.h>

#include <nn/os/os_ThreadTypes.private.h>
#include <nn/os/os_ThreadApi.private.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"
#include "detail/os_ThreadManager.h"

namespace nn { namespace os {

//-----------------------------------------------------------------------------
//  対象スレッドの中断
//
int SuspendThread(ThreadType* thread) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( thread->_state == ThreadType::State_Started );
    NN_SDK_REQUIRES( thread != detail::GetCurrentThread() );

    return detail::GetThreadManagerInstance()->SuspendThread(thread);
}


//--------------------------------------------------------------------------
//  対象スレッドの再開
//
int ResumeThread(ThreadType* thread) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( thread->_state == ThreadType::State_Started );

    return detail::GetThreadManagerInstance()->ResumeThread(thread);
}


//--------------------------------------------------------------------------
//  対象スレッドのサスペンドカウントの取得
//
int GetThreadSuspendCount(const ThreadType* thread) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( thread->_state != ThreadType::State_NotInitialized );

    return thread->_suspendCount;
}


//--------------------------------------------------------------------------
//  対象スレッドのコンテキスト情報の取得
void GetThreadContext(ThreadContextInfo* context, const ThreadType* thread) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( thread->_state == ThreadType::State_Started );

    detail::GetThreadManagerInstance()->GetThreadContext(context, thread);
}


//-----------------------------------------------------------------------------

}} // namespace nn::os

