﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_SdkThreadInfo.h>

#include "detail/os_ThreadInfoImpl.h"

//---------------------------------------------------------------------------
// C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace os {

Result GetLastThreadInfo(ThreadType** pOutThread, SdkLastThreadContext* pOutLastThreadContext, Bit32* pOutFlag) NN_NOEXCEPT
{
    NN_SDK_ASSERT(pOutThread);
    NN_SDK_ASSERT(pOutLastThreadContext);
    NN_SDK_ASSERT(pOutFlag);
    return detail::GetLastThreadInfoImpl(pOutThread, pOutLastThreadContext, pOutFlag);
}

void GetThreadStackInfo(uintptr_t* pOutStackTop, size_t* pOutStackSize, const ThreadType* thread) NN_NOEXCEPT
{
    if (thread->_state != ThreadType::State_Started)
    {
        // スレッドの状態が Started 以外の場合にはスタック情報を返さない
        // - Initialized の場合は最後に動作したスレッドとして検出されることがないはず
        // - Exited 以降ではスタックのエイリアスがアンマップされている可能性がある
        //   アンマップされた領域に触ると例外が発生するため触れないように NULL を返す
        if (pOutStackTop)
        {
            *pOutStackTop = 0;
        }
        if (pOutStackSize)
        {
            *pOutStackSize = 0;
        }
        return;
    }

    return detail::GetThreadStackInfoImpl(pOutStackTop, pOutStackSize, thread);
}

}}  // namespace nn::os

