﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <mutex>
#include <atomic>

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_TimeSpan.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/os/os_LightEventTypes.h>
#include <nn/os/os_LightEventApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"
#include "detail/os_TimeoutHelper.h"

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "detail/os_LightEventImpl-os.horizon.h"
#else
    #include "detail/os_LightEventImpl-os.win32.h"
#endif

namespace nn { namespace os {

#define NN_OS_REQUIRES_TIMEOUT_IS_PLUS_OR_ZERO(tmout) \
        NN_SDK_REQUIRES( (tmout).GetNanoSeconds() >= 0, NN_TEXT_OS("nn::os::%s(): タイムアウト値が不正です。"), NN_CURRENT_FUNCTION_NAME)

//-----------------------------------------------------------------------------

void InitializeLightEvent(LightEventType* event, bool initiallySignaled, EventClearMode clearMode) NN_NOEXCEPT
{
    detail::InitializeLightEventImpl(event, initiallySignaled, clearMode);
}

void FinalizeLightEvent(LightEventType* event) NN_NOEXCEPT
{
    detail::FinalizeLightEventImpl(event);
}

void SignalLightEvent(LightEventType* event) NN_NOEXCEPT
{
    NN_OS_REQUIRES_INITIALIZED(event);

    detail::SignalLightEventImpl(event);
}

void ClearLightEvent(LightEventType* event) NN_NOEXCEPT
{
    NN_OS_REQUIRES_INITIALIZED(event);

    detail::ClearLightEventImpl(event);
}

void WaitLightEvent(LightEventType* event) NN_NOEXCEPT
{
    NN_OS_REQUIRES_INITIALIZED(event);

    detail::WaitLightEventImpl(event);
}

bool TryWaitLightEvent(LightEventType* event) NN_NOEXCEPT
{
    NN_OS_REQUIRES_INITIALIZED(event);

    return detail::TryWaitLightEventImpl(event);
}

bool TimedWaitLightEvent(LightEventType* event, TimeSpan timeout) NN_NOEXCEPT
{
    NN_OS_REQUIRES_INITIALIZED(event);
    NN_OS_REQUIRES_TIMEOUT_IS_PLUS_OR_ZERO(timeout);

    return detail::TimedWaitLightEventImpl(event, timeout);
}

//---------------------------------------------------------------------------

}} // namespace nn::os

