﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_Config.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/dd/dd_DeviceAddressSpaceTypes.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include <nn/svc/svc_Handle.h>
#elif defined(NN_BUILD_CONFIG_OS_WIN32)
    #include <nn/nn_Windows.h>
#endif


namespace {
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    inline nn::os::NativeHandle GetCurrentProcessHandleImpl() NN_NOEXCEPT
    {
        return static_cast<nn::os::NativeHandle>(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS.value);
    }
#elif defined(NN_BUILD_CONFIG_OS_WIN32)
    inline nn::os::NativeHandle GetCurrentProcessHandleImpl() NN_NOEXCEPT
    {
        return reinterpret_cast<nn::os::NativeHandle>(::GetCurrentProcess());
    }
#endif
}

//-----------------------------------------------------------------------------

namespace nn { namespace dd {

//  この関数だけは、アプリケーションプロセス上の shim から呼ばれるため、
//  nn::dd 名前空間だが libnn_os に入れておく。
ProcessHandle GetCurrentProcessHandle() NN_NOEXCEPT
{
    return static_cast<ProcessHandle>(GetCurrentProcessHandleImpl());
}

}}  // namespace nn::dd

//-----------------------------------------------------------------------------

namespace nn { namespace os {

NativeHandle GetCurrentProcessHandle() NN_NOEXCEPT
{
    return GetCurrentProcessHandleImpl();
}

}}  // namespace nn::os

