﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Compiler.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAbort.h>

#include <nn/os/os_UserExceptionHandler.h>

#include "detail/os_DefaultUserExceptionHandlerImpl.h"

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    // 文字コードエンコーディングに関する警告の抑制
    #pragma warning( disable : 4566 )
#endif


namespace nn { namespace os {

//-----------------------------------------------------------------------------
//  デフォルトユーザー例外ハンドラ
//
void DefaultUserExceptionHandler(nn::os::UserExceptionInfo* info) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_WIN32)

    NN_UNUSED( info );

#elif defined(NN_BUILD_CONFIG_OS_HORIZON)

#if !defined(NN_SDK_BUILD_RELEASE)
    uintptr_t stackTop;
    uintptr_t stackBottom;

    // ヘッダの表示
    NN_SDK_LOG("\n");
    detail::PrintExceptionHeader(info);

    // 例外種別の表示
    detail::PrintExceptionType(info);

    // スレッド/ファイバー及びスタック情報の表示
    detail::PrintThreadInformation(info, &stackTop, &stackBottom);

    // 汎用レジスタ一覧の表示
    detail::PrintGeneralPurposeRegisters(info);

    // 特別なレジスタの表示
    detail::PrintSpecialRegisters(info);

    // 浮動小数点レジスタの表示
    detail::PrintFloatingPointRegisters(info);

    // スタックトレースの表示
    detail::PrintStackTrace(info);

    // スタックダンプの表示
    detail::PrintStackDump(info, stackTop, stackBottom);

    // メモリ情報の表示
    detail::PrintMemoryInformation();
#endif // !defined(NN_SDK_BUILD_RELEASE)

    if (!nn::os::detail::IsApplication())
    {
        NN_ABORT_FROM_USER_EXCEPTION_HANDLER(info);
    }
#endif
}

}}  // namespace nn::os

