﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/os/os_Cache.h>

#include "detail/os_CacheImpl.h"

namespace nn { namespace os {

void FlushDataCache( const void* addr, size_t size ) NN_NOEXCEPT
{
    detail::FlushDataCacheImpl( addr, size );
}

void FlushEntireDataCache() NN_NOEXCEPT
{
    detail::FlushEntireDataCacheImpl();
}

}}  // namespace nn::os
