﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_Argument.h>

#include "detail/os_Common.h"

namespace nn { namespace os {

//--------------------------------------------------------------------------

namespace detail {

struct CommandLineParameter
{
    int     argc;
    char**  argv;
};

const char*             g_CommandLineParameterArgv[2] = { "", NULL };
CommandLineParameter    g_CommandLineParameter =
{
    1,                                              // argc
    const_cast<char**>(g_CommandLineParameterArgv), // argv
};

}   //  namespace detail

//--------------------------------------------------------------------------

void SetHostArgc(int argc) NN_NOEXCEPT
{
    detail::g_CommandLineParameter.argc = argc;
}

int GetHostArgc() NN_NOEXCEPT
{
    return detail::g_CommandLineParameter.argc;
}


void SetHostArgv(char** argv) NN_NOEXCEPT
{
    detail::g_CommandLineParameter.argv = argv;
}

char** GetHostArgv() NN_NOEXCEPT
{
    return detail::g_CommandLineParameter.argv;
}

//--------------------------------------------------------------------------

}}   //  namespace nn::os
