﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/nn_Windows.h>

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

#if defined(NN_BUILD_CONFIG_CPU_X64) // 64bit のみ対応

class VammManagerImplByWin32
{
public:
    static void GetReservedRegionImpl(uintptr_t* pOutStart, uintptr_t* pOutSize)
    {
        //
        // Horizon と挙動を共通化するため、最初に 64GB の空間を確保し、内部は nn::os で管理する
        //
        const size_t ReservedRegionSize = 64ull * 1024 * 1024 * 1024; // 64GB
        auto address = ::VirtualAlloc(nullptr, ReservedRegionSize, MEM_RESERVE, PAGE_READWRITE);
        NN_ABORT_UNLESS(address != nullptr);

        *pOutStart = reinterpret_cast<uintptr_t>(address);
        *pOutSize =  ReservedRegionSize;
    }

    static nn::Result AllocatePhysicalMemoryImpl(uintptr_t address, size_t size)
    {
        if (::VirtualAlloc(reinterpret_cast<LPVOID>(address), size, MEM_COMMIT, PAGE_READWRITE) == nullptr)
        {
            return nn::os::ResultOutOfMemory();
        }

        NN_RESULT_SUCCESS;
    }

    static nn::Result FreePhysicalMemoryImpl(uintptr_t address, size_t size)
    {
        if (::VirtualFree(reinterpret_cast<LPVOID>(address), size, MEM_DECOMMIT) == false)
        {
            return nn::os::ResultBusy();
        }

        NN_RESULT_SUCCESS;
    }

    static size_t GetExtraSystemResourceAssignedSize()
    {
        return 0;
    }

    static size_t GetExtraSystemResourceUsedSize()
    {
        return 0;
    }

    static bool IsVirtualAddressMemoryEnabled()
    {
        return true;
    }
};

typedef VammManagerImplByWin32    VammManagerImpl;

#endif

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

