﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include "os_AssemblyOffset.h"

#ifndef NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#error not define NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#endif

    .section ".text", "ax"
    .align   2
    .global  _ZN2nn2os6detail20UserExceptionHandlerEv
    .type    _ZN2nn2os6detail20UserExceptionHandlerEv, %function
_ZN2nn2os6detail20UserExceptionHandlerEv:

    //-------------------------------------------------------------------------
    // [この時点でのレジスタの状態]
    //  r0 = 例外要因
    //  r1 = プロセス固有領域上の nn::svc::ExceptionInfo へのポインタ
    //  sp = プロセス固有領域上のスタックの底（スタックサイズは僅か）
    //-------------------------------------------------------------------------
    // まず、デマンドロードが必要かどうかをチェック
    // <未実装>

    ldr     r6, .LGOT
    adr     r7, .LGOT
    add     r6, r6, r7      // r6 <- GOT

    // ユーザ例外ハンドラが未設定ならばデフォルト処理へ
    ldr     r7, .L_ZN2nn2os6detail22g_UserExceptionHandlerE
    ldr     r7, [r6, r7]    // r7 <- _ZN2nn2os6detail22g_UserExceptionHandlerE
    ldr     r7, [r7]
    cmp     r7, #0
    beq     .Lnot_handled

    mov     r4, r0
    mov     r5, r1

    // デバッガが未接続ならユーザ例外ハンドラを呼出す
    bl      2f
1:  .word   __pout_64 - 1b
2:  ldr     r7, [lr]
    add     r7, r7, lr
    mov     r0, r7
    mov     r1, #NN_SVC_INFOTYPE_DEBUGGER_PRESENCE  // InfoType_DebuggerPresence
    mov     r2, #0                                  // handle
    push    {r2}                                    // param
    push    {r2}                                    // param
    ldr     r3, .L_ZN2nn3svc7aarch327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    ldr     r3, [r6, r3]    // r3 <- _ZN2nn3svc7aarch327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    blx     r3
    add     sp, sp, #0x8
    cmp     r0, #0          // result
    bne     .Lnot_handled
    ldr     r0, [r7, #0x4]
    cmp     r0, #0          // pOut の上位 32bit
    bne     .Lnot_handled
    ldr     r0, [r7]
    cmp     r0, #0          // pOut の下位 32bit、0 なら非アタッチ状態
    beq     _prepare_to_invoke_user_exception_handler

    // デバッガ接続中でもユーザ例外ハンドラを起動すべきか
    ldr     r7, .L_ZN2nn2os6detail41g_UserExceptionHandlerValidityOnDebuggingE
    ldr     r7, [r6, r7]    // r7 <- nn::os::detail::g_UserExceptionHandlerValidityOnDebugging
    ldrb    r7, [r7]
    cmp     r7, #0          // false ならデフォルト処理へ
    beq     .Lnot_handled

_prepare_to_invoke_user_exception_handler:
    //-------------------------------------------------------------------------
    // nn::os::detail::PrepareToCopyUserExceptionInfo() を呼ぶ。
    //  r0= 例外要因
    //  r1= nn::svc::ExceptionInfo へのポインタ
    //
    // nn::os::UserExceptioinInfoDetail のアドレスを r0 で返す。
    // r0 == NULL の場合は、メモリアクセス不可等を検出したため、
    // デフォルト処理へ移行する
    //

    mov     r0, r4
    mov     r1, r5
    b       _prepare_to_copy_user_exception_info

    // OUPUT:   r0: nn::os::UserExceptionInfoDetail へのポインタ
    //          r1: nn::svc::ExceptionInfo へのポインタ
    //          r6: nn::svc::ExceptionInfo.r[0] に代入すべき値
    //          r7: nn::svc::ExceptionInfo.sp   に代入すべき値

_prepare_to_copy_user_exception_info_return:
    cmp     r0, #0
    beq     .Lnot_handled

    mov     r4, r0
    mov     r5, r1

    // nn::os::UserExceptionInfoDetail 構造体の構築
    //  r4 = nn::os::UserExceptionInfoDetail の先頭アドレス
    //  r5 = nn::svc::ExceptionInfo の先頭アドレス
    //
    // コードの最適化は度外視

#define NN_LDST32_EXCEPTION_INFO(to, from)                  \
        ldr     r0, [r5, #NN_SVC_EXCEPTION_INFO_##from];    \
        str     r0, [r4, #NN_OS_EXCEPTION_INFO_##to]

#define NN_LDST32_EXCEPTION_INFO_STATUS_EQ(to, from)                                                   \
        ldreq   r0, [r5, #NN_SVC_EXCEPTION_INFO_##from + NN_SVC_EXCEPTION_INFO_AA32_OFFSET_STATUS]; \
        streq   r0, [r4, #NN_OS_EXCEPTION_INFO_##to]

#define NN_LDST32_EXCEPTION_INFO_STATUS_NE(to, from)                                                   \
        ldrne   r0, [r5, #NN_SVC_EXCEPTION_INFO_##from + NN_SVC_EXCEPTION_INFO_AA32_OFFSET_STATUS]; \
        strne   r0, [r4, #NN_OS_EXCEPTION_INFO_##to]

    // CPU 汎用レジスタ r0～r15（各 32 bit）をコピー
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R0, AA32_OFFSET_R0 )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_SP, AA32_OFFSET_SP )

    str     r6, [r5, #NN_SVC_EXCEPTION_INFO_AA32_OFFSET_R0]
    str     r7, [r5, #NN_SVC_EXCEPTION_INFO_AA32_OFFSET_SP]

    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R1, AA32_OFFSET_R1 )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R2, AA32_OFFSET_R2 )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R3, AA32_OFFSET_R3 )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R4, AA32_OFFSET_R4 )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R5, AA32_OFFSET_R5 )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R6, AA32_OFFSET_R6 )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_R7, AA32_OFFSET_R7 )

    str     r8,  [r4, #NN_OS_EXCEPTION_INFO_AA32S32_OFFSET_R8 ]
    str     r9,  [r4, #NN_OS_EXCEPTION_INFO_AA32S32_OFFSET_R9 ]
    str     r10, [r4, #NN_OS_EXCEPTION_INFO_AA32S32_OFFSET_R10]
    str     r11, [r4, #NN_OS_EXCEPTION_INFO_AA32S32_OFFSET_R11]
    str     r12, [r4, #NN_OS_EXCEPTION_INFO_AA32S32_OFFSET_R12]

    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_LR, AA32_OFFSET_LR )
    NN_LDST32_EXCEPTION_INFO( AA32S32_OFFSET_PC, AA32_OFFSET_PC )

    // VFP ベクタレジスタ D0～D31（各 64 bit）をセット
    mov     r0, sp
    add     sp, r4, #NN_OS_EXCEPTION_INFO_AA32S32_OFFSET_D0
#if NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS == 32
    add     sp, #0x100      // 64bit * 32
    vpush   {d16-d31}
#else
    add     sp, #0x80       // 64bit * 16
#endif
    vpush   {d0-d15}
    mov     sp, r0

    // 例外情報をコピー
    ldr     r0, [r5, #NN_SVC_EXCEPTION_INFO_AA32_OFFSET_FLAGS]
    ands    r0, #0x1

    NN_LDST32_EXCEPTION_INFO_STATUS_EQ( AA32S32_OFFSET_CPSR,    AA32S32_OFFSET_CPSR    )
    NN_LDST32_EXCEPTION_INFO_STATUS_EQ( AA32S32_OFFSET_FSR,     AA32S32_OFFSET_FSR     )
    NN_LDST32_EXCEPTION_INFO_STATUS_EQ( AA32S32_OFFSET_FAR,     AA32S32_OFFSET_FAR     )
    NN_LDST32_EXCEPTION_INFO_STATUS_EQ( AA32S32_OFFSET_FPEXC,   AA32S32_OFFSET_FPEXC   )
    NN_LDST32_EXCEPTION_INFO_STATUS_EQ( AA32S32_OFFSET_FPINST,  AA32S32_OFFSET_FPINST  )
    NN_LDST32_EXCEPTION_INFO_STATUS_EQ( AA32S32_OFFSET_FPINST2, AA32S32_OFFSET_FPINST2 )

    NN_LDST32_EXCEPTION_INFO_STATUS_NE( AA32S64_OFFSET_PSTATE,  AA32S64_OFFSET_PSTATE  )
    NN_LDST32_EXCEPTION_INFO_STATUS_NE( AA32S64_OFFSET_AFSR0,   AA32S64_OFFSET_AFSR0   )
    NN_LDST32_EXCEPTION_INFO_STATUS_NE( AA32S64_OFFSET_AFSR1,   AA32S64_OFFSET_AFSR1   )
    NN_LDST32_EXCEPTION_INFO_STATUS_NE( AA32S64_OFFSET_ESR,     AA32S64_OFFSET_ESR     )
    NN_LDST32_EXCEPTION_INFO_STATUS_NE( AA32S64_OFFSET_FAR,     AA32S64_OFFSET_FAR     )

    // svc::ExceptionInfo の pc を変更
    adr     r0, _entry_of_user_exception_handler
    str     r0, [r5, #NN_SVC_EXCEPTION_INFO_AA32_OFFSET_PC]


    // 一旦カーネルに戻る
    ldr     r0, =RESULT_SUCCESS
    ldr     r1, .LGOT
    adr     r3, .LGOT
    add     r1, r1, r3      // r1 <- GOT
    ldr     r3, .L_ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE
    ldr     r3, [r1, r3]    // r3 <- _ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE
    blx     r3

_entry_of_user_exception_handler:
    //------------------------------------------------------------
    // svc::ReturnFromException() からの復帰位置。
    //  r0 = nn::os::UserExceptionInfo* のポインタ
    //  sp = ユーザ例外ハンドラ用のスタック
    //

    ldr     ip, .LGOT
    adr     r1, .LGOT
    add     ip, ip, r1      // ip <- GOT
    ldr     r1, .L_ZN2nn2os6detail22g_UserExceptionHandlerE
    ldr     r1, [ip, r1]    // r1 <- _ZN2nn2os6detail22g_UserExceptionHandlerE
    ldr     r1, [r1]
    cmp     r1, #0

    // ユーザ例外ハンドラの呼出し
    blxne   r1

.Lpanic:
    // panic へ移行
    ldr     ip, .LGOT
    adr     r3, .LGOT
    add     ip, ip, r3      // ip <- GOT

    ldr     r0, =NN_SVC_BREAKREASON_PANIC
    mov     r1, #0
    mov     r2, #0
    ldr     r3, .L_ZN2nn3svc7aarch325BreakENS0_11BreakReasonEjj
    ldr     r3, [ip, r3]    // r3 <- _ZN2nn3svc7aarch325BreakENS0_11BreakReasonEjj
    blx     r3
0:  b       0b

.Lnot_handled:
    ldr     ip, .LGOT
    adr     r3, .LGOT
    add     ip, ip, r3      // ip <- GOT

    ldr     r0, =RESULT_NOT_HANDLED
    ldr     r3, .L_ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE
    ldr     r3, [ip, r3]    // r3 <- _ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE
    blx     r3
6:  b       6b


    //------------------------------------------------------------
    // os::detail::PrepareToCopyUserExceptionInfo() と等価コード。
    // ただし、こちらに配置することで、関数呼出時のシンボル解決が
    // 不要となり、スタックを消費せずに同様の処理を行なう。
    //
    // INPUT:   r0: 例外要因
    //          r1: nn::svc::ExceptionInfo へのポインタ
    // OUPUT:   r0: nn::os::UserExceptionInfoDetail へのポインタ
    //          r1: nn::svc::ExceptionInfo へのポインタ
    //          r6: nn::svc::ExceptionInfo.r[0] に代入すべき値
    //          r7: nn::svc::ExceptionInfo.sp   に代入すべき値
    // WARNING: r8-r12 は破壊禁止
    //
_prepare_to_copy_user_exception_info:
    mov     r5, r1

    ldr     r6, .LGOT
    adr     lr, .LGOT
    add     r6, r6, lr      // r6 <- GOT

    ldr     r4, .L_ZN2nn2os6detail19g_UserExceptionInfoE
    ldr     r4, [r6, r4]    // r4 <- _ZN2nn2os6detail19g_UserExceptionInfoE
    ldr     r4, [r4]
    ldr     r3, [r1, #NN_SVC_EXCEPTION_INFO_AA32_OFFSET_SP]
    sub     lr, r3, #NN_OS_SIZEOF_USER_EXCEPTION_INFO
    ldr     r7, .L_ZN2nn2os6detail26g_UserExceptionStackBottomE
    ldr     r7, [r6, r7]    // r7 <- _ZN2nn2os6detail26g_UserExceptionStackBottomE
    ldr     r7, [r7]
    mov     r2, r7

    // この時点で r7: g_UserExceptionStackBottom の値
    //            r2: handlerStackBottom の値
    //            r4: info の値
    //            r3: 例外発生時の threadStack
    //            lr: 例外発生時の threadStack - sizeof(UserExceptionInfo)

    cmp     r4, #NN_OS_USER_EXCEPTION_INFO_USES_THREAD_STACK
    moveq   r3, lr
    moveq   r4, r3

    cmp     r2, #NN_OS_HANLDER_STACK_USES_THREAD_STACK
    moveq   r2, r3

    cmp     r4, #NN_OS_USER_EXCEPTION_INFO_USES_HANDLER_STACK
    bne     .Lprepare_to_copy_user_exception_info_memory_check
    sub     r2, r2, #NN_OS_SIZEOF_USER_EXCEPTION_INFO
    mov     r4, r2
    cmp     r7, #NN_OS_HANLDER_STACK_USES_THREAD_STACK
    beq     .Lprepare_to_copy_user_exception_info_memory_check
    ldr     r7, .L_ZN2nn2os6detail23g_UserExceptionStackTopE
    ldr     r7, [r6, r7]    // r7 <- _ZN2nn2os6detail23g_UserExceptionStackTopE
    ldr     r7, [r7]
    cmp     r2, r7
    movls   r0, #0
    bls     _prepare_to_copy_user_exception_info_return

.Lprepare_to_copy_user_exception_info_memory_check:
    mov     r6, r0
    mov     r7, r2

    //  r4: info の値
    //  r5: nn::svc::ExceptionInfo へのポインタ
    //  r6: 例外要因
    //  r7: handlerStackBottom の値

    // info へのメモリアクセス可否チェック
    bl      2f
1:  .word   __memory_info - 1b
2:  ldr     r0, [lr]
    add     r0, r0, lr
    bl      2f
1:  .word   __pout_64 - 1b
2:  ldr     r1, [lr]
    add     r1, r1, lr
    mov     r2, r4
    push    {r0, r1}

    ldr     ip, .LGOT
    adr     r3, .LGOT
    add     ip, ip, r3      // ip <- GOT
    ldr     r3, .L_ZN2nn3svc7aarch3211QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj
    ldr     r3, [ip, r3]    // r3 <- _ZN2nn3svc7aarch3211QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj
    blx     r3

    pop     {r1, r2}
    cmp     r0, #0
    bne     .Lprepare_to_copy_user_exception_info_return_null

    ldr     r0, [r1, #NN_SVC_MEMORY_INFO_OFFSET_PERMISSION]
    cmp     r0, #NN_SVC_MEMORY_PERMISSION_READWRITE
    bne     .Lprepare_to_copy_user_exception_info_return_null

    // handlerStackBottom へのメモリアクセス可否チェック
    mov     r0, r1
    mov     r1, r2
    mov     r2, r7
    push    {r0}
    ldr     ip, .LGOT
    adr     r3, .LGOT
    add     ip, ip, r3      // ip <- GOT
    ldr     r3, .L_ZN2nn3svc7aarch3211QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj
    ldr     r3, [ip, r3]    // r3 <- _ZN2nn3svc7aarch3211QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj
    blx     r3
    pop     {r1}
    cmp     r0, #0
    bne     .Lprepare_to_copy_user_exception_info_return_null

    ldr     r0, [r1, #NN_SVC_MEMORY_INFO_OFFSET_PERMISSION]
    cmp     r0, #NN_SVC_MEMORY_PERMISSION_READWRITE
    bne     .Lprepare_to_copy_user_exception_info_return_null

.Lprepare_to_copy_user_exception_success:
    str     r6, [r4, #NN_OS_EXCEPTION_INFO_OFFSET_EXCEPTION_TYPE]
    mov     r6, r4
    add     r0, r4, #NN_OS_EXCEPTION_INFO_OFFSET_DETAIL
    mov     r1, r5
    b       _prepare_to_copy_user_exception_info_return

.Lprepare_to_copy_user_exception_info_return_null:
    mov     r0, #0
    mov     r1, r5
    b       _prepare_to_copy_user_exception_info_return


    .size   _ZN2nn2os6detail20UserExceptionHandlerEv, [. - _ZN2nn2os6detail20UserExceptionHandlerEv]

.LGOT:
    .word _GLOBAL_OFFSET_TABLE_ - .LGOT
.L_ZN2nn2os6detail22g_UserExceptionHandlerE:
    .word _ZN2nn2os6detail22g_UserExceptionHandlerE(GOT)
.L_ZN2nn2os6detail41g_UserExceptionHandlerValidityOnDebuggingE:
    .word _ZN2nn2os6detail41g_UserExceptionHandlerValidityOnDebuggingE(GOT)
.L_ZN2nn2os6detail19g_UserExceptionInfoE:
    .word _ZN2nn2os6detail19g_UserExceptionInfoE(GOT)
.L_ZN2nn2os6detail26g_UserExceptionStackBottomE:
    .word _ZN2nn2os6detail26g_UserExceptionStackBottomE(GOT)
.L_ZN2nn2os6detail23g_UserExceptionStackTopE:
    .word _ZN2nn2os6detail23g_UserExceptionStackTopE(GOT)
.L_ZN2nn3svc7aarch327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy:
    .word _ZN2nn3svc7aarch327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy(GOT)
.L_ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE:
    .word _ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE(GOT)
.L_ZN2nn3svc7aarch325BreakENS0_11BreakReasonEjj:
    .word _ZN2nn3svc7aarch325BreakENS0_11BreakReasonEjj(GOT)
.L_ZN2nn3svc7aarch3211QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj:
    .word _ZN2nn3svc7aarch3211QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj(GOT)

    .bss
    .balign 8
__pout_64:
    .space  8
    .size   __pout_64, [. - __pout_64]

    .bss
    .balign 8
__memory_info:
    .space  NN_SVC_SIZEOF_MEMORY_INFO
    .size   __memory_info, [. - __memory_info]
