﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/nn_Windows.h>

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

class UnsafeMemoryManagerImplByWin32
{
public:
    static Result AllocateUnsafeMemoryImpl(uintptr_t* pOutAddress, size_t size)
    {
        NN_UNUSED(pOutAddress);
        NN_UNUSED(size);
        NN_RESULT_SUCCESS;
    }

    static Result FreeUnsafeMemoryImpl(uintptr_t address, size_t size)
    {
        NN_UNUSED(address);
        NN_UNUSED(size);
        NN_RESULT_SUCCESS;
    }
};

typedef UnsafeMemoryManagerImplByWin32 UnsafeMemoryManagerImpl;

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

