﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#if !defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN32)
    #error  "OS 種別として Win32 が指定されていません。"
#endif

#include <nn/nn_Windows.h>

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include "os_TickManager.h"

//--------------------------------------------------------------------------
//  C++ 向けのプロトタイプ宣言
//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

typedef DWORD   InternalTargetTimeSpan;

//--------------------------------------------------------------------------
//  TimeoutHelperImplByWin32 クラス
//
class TimeoutHelperImplByWin32
{
public:
    static InternalTargetTimeSpan ConvertToImplTime( Tick tick ) NN_NOEXCEPT;
    static void Sleep( TimeSpan time ) NN_NOEXCEPT;
};

typedef TimeoutHelperImplByWin32    TimeoutHelperImpl;



//--------------------------------------------------------------------------
//  Tick 単位から Win32 環境での時間（ミリ秒）単位へ変換する
inline InternalTargetTimeSpan TimeoutHelperImplByWin32::ConvertToImplTime( Tick tick ) NN_NOEXCEPT
{
    const int64_t maxTime = (std::numeric_limits<int64_t>::max)() - nn::TimeSpan::FromMilliSeconds(1).GetNanoSeconds();
    const auto    ratio   = nn::TimeSpan::FromMilliSeconds( 1 );
    const auto    oneNano = nn::TimeSpan::FromNanoSeconds( 1 );
    auto          time    = nn::TimeSpan::FromNanoSeconds( std::min<int64_t>(maxTime, detail::GetTickManagerInstance()->ConvertToTimeSpan( tick ).GetNanoSeconds()) );
    return  static_cast<InternalTargetTimeSpan>(( time + ratio - oneNano ).GetMilliSeconds() );
}


}   // namespace detail
}}  // namespace nn::os

