﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>

#include "os_TickManager.h"

namespace nn { namespace os { namespace detail {

typedef TimeSpan    InternalTargetTimeSpan;

class TimeoutHelperImplByHorizon
{
public:
    static InternalTargetTimeSpan ConvertToImplTime(Tick tick) NN_NOEXCEPT
    {
        return GetTickManagerInstance()->ConvertToTimeSpan( tick );
    }

    static void Sleep(TimeSpan time) NN_NOEXCEPT;
};

typedef TimeoutHelperImplByHorizon TimeoutHelperImpl;

}}}  // namespace nn::os::detail

