﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>
#include <nn/os.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_HardwareParamsSelect.h>

namespace nn { namespace os { namespace detail {

class TickManagerImplByHorizon
{
public:
    Tick GetTick() const NN_NOEXCEPT
    {
        int64_t tick;

#if defined(NN_BUILD_CONFIG_CPU_ARM) && defined(NN_BUILD_CONFIG_CPU_ARM_VE)
        asm volatile ("mrrc p15, 0, %Q0, %R0, c14": "=&r"(tick)::"memory");
#elif defined(NN_BUILD_CONFIG_CPU_ARM64) && defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
        asm volatile ("mrs %0, cntpct_el0": "=&r"(tick)::"memory");
#else
        tick = nn::svc::GetSystemTick();
#endif
        return Tick( tick );
    }

    constexpr int64_t GetTickFrequency() const NN_NOEXCEPT
    {
        return static_cast<int64_t>(NN_HW_TICKS_PER_SECOND);
    }
};

typedef TickManagerImplByHorizon TickManagerImpl;

}}}  // namespace nn::os::detail

