﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_Types.h>
#include <nn/os/os_SdkThreadInfo.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace os {
namespace detail {

inline Result GetLastThreadInfoImpl(ThreadType** pOutThread, SdkLastThreadContext* pOutLastThreadContext, Bit32* pOutFlag) NN_NOEXCEPT
{
    NN_UNUSED(pOutThread);
    NN_UNUSED(pOutLastThreadContext);
    NN_UNUSED(pOutFlag);
    return os::ResultNoThread();
}

inline void GetThreadStackInfoImpl(uintptr_t* pOutStackTop, size_t* pOutStackSize, const ThreadType* thread) NN_NOEXCEPT
{
    NN_UNUSED(pOutStackTop);
    NN_UNUSED(pOutStackSize);
    NN_UNUSED(thread);
}

}   // namespace detail
}}  // namespace nn::os
