﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/os/os_MemoryHeapCommon.h>

#include "os_AddressSpaceAllocatorTypes.h"

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include "os_StackGuardManagerImpl-os.win32.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "os_StackGuardManagerImpl-os.horizon.h"
#else
    #error   "未サポートの OS 種別が指定されています。"
#endif


namespace nn { namespace os {

struct  ThreadType;

namespace detail {

// スタックガードのサイズ
const size_t StackGuardSize = MemoryPageSize * 4;


//--------------------------------------------------------------------------
// エイリアス空間の管理用クラス
//
class StackGuardManager
{
public:
    //-----------------------------------------------------------------
    // コンストラクタ
    StackGuardManager() NN_NOEXCEPT : m_Allocator(m_Impl.GetStackGuardBeginAddress(), m_Impl.GetStackGuardEndAddress(), StackGuardSize)
    {
    }

    //-----------------------------------------------------------------
    // エイリアス空間からスタック領域が収まる空き空間を獲得しノードを追加する
    void* AllocateStackGuardSpace(size_t stackSize) NN_NOEXCEPT
    {
        return m_Allocator.AllocateSpace(stackSize, MemoryPageSize);
    }

    bool CheckGuardSpace(uintptr_t address, size_t size)
    {
        return m_Allocator.CheckGuardSpace(address, size, StackGuardSize);
    }

private:
    AddressSpaceAllocator   m_Allocator;
    StackGuardManagerImpl   m_Impl;
};

//--------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::os

