﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

class StackGuardManagerImplByWin32
{
public:
    // Horizon/32bit 環境を模倣した疑似スタックガード空間を定義しておく。
    // これらの空間は単なるアドレス管理用で、実際にアクセスされることはない。
    static uint64_t  GetStackGuardBeginAddress() NN_NOEXCEPT
    {
        return 0x10000000ull;
    }
    static uint64_t  GetStackGuardEndAddress() NN_NOEXCEPT
    {
        return 0x50000000ull;
    }
};

typedef StackGuardManagerImplByWin32    StackGuardManagerImpl;

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

