﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/os/os_NativeHandleTypes.h>

namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------

class SharedMemoryImplByHorizon
{
public:
    static nn::Result Create(NativeHandle* handle, size_t size, MemoryPermission myPermission, MemoryPermission otherPermission) NN_NOEXCEPT;

    static void  Close(NativeHandle handle) NN_NOEXCEPT;

    static Result Map(void** pOutAddress, NativeHandle handle, void* address, size_t size, MemoryPermission myPermission) NN_NOEXCEPT;

    static void  Unmap(NativeHandle handle, void* address, size_t size) NN_NOEXCEPT;
};

typedef SharedMemoryImplByHorizon   SharedMemoryImpl;

//---------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

