﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>

#include "os_Common.h"
#include "os_OsResourceManager.h"


namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
// 通常の静的オブジェクトとは異なり、OS ライブラリ内のグローバルな
// 静的オブジェクトは全て nnosInitialize() が呼ばれたタイミングで
// コンストラクタを起動させる必要があるので、逆に通常のタイミングで
// コンストラクタが呼ばれないように TypedStorage<> にしておく。
//
// nnosInitialize() は、nninitStartup() や通常の静的オブジェクトの
// コンストラクタよりも前に呼ばれる。
//
util::TypedStorage<OsResourceManager,sizeof(OsResourceManager),NN_ALIGNOF(OsResourceManager)> g_OsResourceManagerStorage;

//---------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

