﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_Result.h>

#include "os_Diag.h"
#include "os_Common.h"

namespace nn { namespace os { namespace detail {

//--------------------------------------------------------------------------
//  NativeHandleImplByHorizon クラス
//

class   NativeHandleImplByHorizon
{
public:
    // メンバ関数
    static void Close(NativeHandle) NN_NOEXCEPT;
};

typedef NativeHandleImplByHorizon   NativeHandleImpl;

//--------------------------------------------------------------------------

inline void NativeHandleImplByHorizon::Close(NativeHandle handle) NN_NOEXCEPT
{
    auto result = svc::CloseHandle( nn::svc::Handle(handle) );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

//--------------------------------------------------------------------------

}}} // namespace nn::os::detail

