﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/os_ThreadTypes.h>

#include "os_Common.h"
#include "os_MultipleWaitHelper.h"
#include "os_MultipleWaitHolderOfThread.h"

//---------------------------------------------------------------------------
//  C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  スレッド用の多重待ちホルダーオブジェクト

// Thread オブジェクトの状態をポーリング
TriBool MultiWaitHolderOfThread::IsSignaled() const NN_NOEXCEPT
{
    // クリティカルセクション
    std::lock_guard<InternalCriticalSection> lock( Get(m_Thread->_csThread) );

    return this->IsSignaledUnsafe();
}

// 多重待ちオブジェクトを、ThreadType の多重待ちリストにリンク
TriBool MultiWaitHolderOfThread::AddToObjectList() NN_NOEXCEPT
{
    // クリティカルセクション
    std::lock_guard<InternalCriticalSection> lock( Get(m_Thread->_csThread) );

    Get( m_Thread->_multiWaitObjectList ).PushBackToList( *this );
    return this->IsSignaledUnsafe();
}

// 多重待ちオブジェクトを、ThreadType の多重待ちリストから外す
void MultiWaitHolderOfThread::RemoveFromObjectList() NN_NOEXCEPT
{
    // クリティカルセクション
    std::lock_guard<InternalCriticalSection> lock( Get(m_Thread->_csThread) );

    Get( m_Thread->_multiWaitObjectList ).EraseFromList( *this );
}

}   // namespace detail
}}  // namespace nn::os

