﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/os_NativeHandleTypes.h>

#include "os_Common.h"
#include "os_MultipleWaitHelper.h"
#include "os_MultipleWaitHolderOfNativeHandle.h"

//-----------------------------------------------------------------------------
//  C++ 関数の定義
//-----------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//-----------------------------------------------------------------------------
// ハンドルが指す対象オブジェクトの状態を返す
TriBool MultiWaitHolderOfNativeHandle::IsSignaled() const NN_NOEXCEPT
{
    return TriBool::Indeterminate;
}

//-----------------------------------------------------------------------------
// カーネルのハンドルを返す
bool MultiWaitHolderOfNativeHandle::GetNativeHandle(NativeHandle* pOut) const NN_NOEXCEPT
{
    *pOut = m_Handle;
    return true;
}

}   // namespace detail
}}  // namespace nn::os

