﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_MessageQueueTypes.h>

#include "os_Common.h"
#include "os_MultipleWaitHolderBase.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {

struct  MessageQueueType;

namespace detail {

//--------------------------------------------------------------------------
//  MessageQueueType（NotFull）用の MultiWaitHolderBase 派生クラス
//
class MultiWaitHolderOfMessageQueueNotFull : public MultiWaitHolderOfUserWaitObject
{
public:
    explicit MultiWaitHolderOfMessageQueueNotFull(MessageQueueType* p) NN_NOEXCEPT
                : m_MessageQueue( p ) {}

    virtual TriBool IsSignaled() const  NN_NOEXCEPT NN_OVERRIDE;
    virtual TriBool AddToObjectList() NN_NOEXCEPT NN_OVERRIDE;
    virtual void RemoveFromObjectList() NN_NOEXCEPT NN_OVERRIDE;

private:
    TriBool IsSignaledUnsafe() const NN_NOEXCEPT
    {
        return m_MessageQueue->_count < m_MessageQueue->_maxCount ? TriBool::True : TriBool::False;
    }

private:
    MessageQueueType*   m_MessageQueue; // 対象オブジェクトへのポインタ
};


//--------------------------------------------------------------------------
//  MessageQueueType（NotEmpty）用の MultiWaitHolderBase 派生クラス
//
class MultiWaitHolderOfMessageQueueNotEmpty : public MultiWaitHolderOfUserWaitObject
{
public:
    explicit MultiWaitHolderOfMessageQueueNotEmpty(MessageQueueType* p) NN_NOEXCEPT
                : m_MessageQueue( p ) {}

    virtual TriBool IsSignaled() const  NN_NOEXCEPT NN_OVERRIDE;
    virtual TriBool AddToObjectList() NN_NOEXCEPT NN_OVERRIDE;
    virtual void RemoveFromObjectList() NN_NOEXCEPT NN_OVERRIDE;

private:
    TriBool IsSignaledUnsafe() const NN_NOEXCEPT
    {
        return m_MessageQueue->_count > 0 ? TriBool::True : TriBool::False;
    }

private:
    MessageQueueType*   m_MessageQueue; // 対象オブジェクトへのポインタ
};


}   // namespace detail
}}  // namespace nn::os

